/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.TlsEndpointContext;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.tcp.netty.TcpContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsContextUtil
extends TcpContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsContextUtil.class);
    private final CertificateAuthenticationMode clientAuthMode;

    public TlsContextUtil(CertificateAuthenticationMode clientAuthMode) {
        this.clientAuthMode = clientAuthMode;
    }

    @Override
    public EndpointContext buildEndpointContext(Channel channel) {
        InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
        String id = channel.id().asShortText();
        SslHandler sslHandler = channel.pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            throw new IllegalStateException("Missing SslHandler for " + id + "!");
        }
        SSLEngine sslEngine = sslHandler.engine();
        SSLSession sslSession = sslEngine.getSession();
        if (sslSession != null) {
            byte[] sessionId;
            boolean checkKerberos = false;
            Object principal = null;
            if (this.clientAuthMode.useCertificateRequest()) {
                try {
                    Certificate[] peerCertificateChain = sslSession.getPeerCertificates();
                    if (peerCertificateChain != null && peerCertificateChain.length != 0) {
                        principal = X509CertPath.fromCertificatesChain((Certificate[])peerCertificateChain);
                    } else {
                        checkKerberos = true;
                    }
                }
                catch (SSLPeerUnverifiedException e1) {
                    checkKerberos = true;
                }
                catch (RuntimeException e) {
                    LOGGER.warn("TLS({}) failed to extract principal {}", (Object)id, (Object)e.getMessage());
                }
                if (checkKerberos) {
                    try {
                        principal = sslSession.getPeerPrincipal();
                    }
                    catch (SSLPeerUnverifiedException e2) {
                        if (this.clientAuthMode == CertificateAuthenticationMode.NEEDED) {
                            LOGGER.warn("TLS({}) failed to verify principal, {}", (Object)id, (Object)e2.getMessage());
                        }
                        LOGGER.trace("TLS({}) failed to verify principal, {}", (Object)id, (Object)e2.getMessage());
                    }
                }
                if (principal != null) {
                    LOGGER.debug("TLS({}) Principal {}", (Object)id, (Object)principal.getName());
                } else if (this.clientAuthMode == CertificateAuthenticationMode.NEEDED) {
                    LOGGER.warn("TLS({}) principal missing", (Object)id);
                } else {
                    LOGGER.trace("TLS({}) principal missing", (Object)id);
                }
            }
            if ((sessionId = sslSession.getId()) != null && sessionId.length > 0) {
                String sslId = StringUtil.byteArray2HexString((byte[])sessionId, (char)'\u0000', (int)0);
                String cipherSuite = sslSession.getCipherSuite();
                LOGGER.debug("TLS({},{},{})", new Object[]{id, StringUtil.trunc((String)sslId, (int)14), cipherSuite});
                return new TlsEndpointContext(address, (Principal)principal, id, sslId, cipherSuite, sslSession.getLastAccessedTime());
            }
        }
        throw new IllegalStateException("TLS handshake " + id + " not ready!");
    }
}

