/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli.tcp.netty;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.eclipse.californium.cli.CliConnectorFactory;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.tcp.netty.TlsClientConnector;
import org.eclipse.californium.elements.util.SslContextUtil;

public class TlsConnectorFactory
implements CliConnectorFactory {
    private static final String ALIAS = "client";

    public Connector create(ClientBaseConfig clientConfig, ExecutorService executor) {
        Configuration config = clientConfig.configuration;
        int maxPeers = (Integer)config.get((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS);
        int sessionTimeout = config.getTimeAsInt(TcpConfig.TLS_SESSION_TIMEOUT, TimeUnit.SECONDS);
        SSLContext clientSslContext = null;
        try {
            KeyManager[] keyManager = clientConfig.authentication.anonymous ? SslContextUtil.createAnonymousKeyManager() : SslContextUtil.createKeyManager((String)ALIAS, (PrivateKey)clientConfig.authentication.credentials.getPrivateKey(), (X509Certificate[])clientConfig.authentication.credentials.getCertificateChain());
            TrustManager[] trustManager = clientConfig.trust.trustall ? SslContextUtil.createTrustAllManager() : SslContextUtil.createTrustManager((String)ALIAS, (Certificate[])clientConfig.trust.trusts);
            clientSslContext = SSLContext.getInstance("TLSv1.2");
            clientSslContext.init(keyManager, trustManager, null);
            SSLSessionContext clientSessionContext = clientSslContext.getClientSessionContext();
            if (clientSessionContext != null) {
                clientSessionContext.setSessionTimeout(sessionTimeout);
                clientSessionContext.setSessionCacheSize(maxPeers);
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return new TlsClientConnector(clientSslContext, clientConfig.configuration);
    }
}

