/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.pack;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.birt.build.framework.Bundle;
import org.eclipse.birt.build.framework.BundleEntry;
import org.eclipse.birt.build.framework.BundleFile;
import org.eclipse.birt.build.framework.Framework;
import org.eclipse.birt.build.pack.Filter;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FrameworkPacker {
    static Logger logger = Logger.getLogger(FrameworkPacker.class.getName());
    HashSet<String> existingEntries = new HashSet();
    HashMap<String, Filter> filters = new HashMap();
    Framework framework;

    public FrameworkPacker(Framework framework) {
        this.framework = framework;
    }

    public void setFilter(String bundleId, Filter filter) {
        this.filters.put(bundleId, filter);
    }

    public void pack(ZipOutputStream zipOutput) throws IOException, ParserConfigurationException, TransformerException {
        this.packFiles(zipOutput);
        this.packDescription(zipOutput);
    }

    public void packFiles(ZipOutputStream zipOutput) throws IOException {
        List<Bundle> bundles = this.framework.getAllBundles();
        for (Bundle bundle : bundles) {
            List<Bundle> fragments;
            if (!bundle.isFragment() && (fragments = bundle.getFragments()) != null) {
                for (Bundle fragment : fragments) {
                    this.packBundle(zipOutput, fragment);
                }
            }
            this.packBundle(zipOutput, bundle);
        }
    }

    public void packDescription(ZipOutputStream zipOutput) throws IOException, ParserConfigurationException, TransformerException {
        ZipEntry entry = new ZipEntry("plugin.xml");
        zipOutput.putNextEntry(entry);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element documentRoot = document.createElement("plugin");
            document.appendChild(documentRoot);
            List<Bundle> bundles = this.framework.getAllBundles();
            for (Bundle bundle : bundles) {
                Document description;
                List<Bundle> fragments;
                if (!bundle.isFragment() && (fragments = bundle.getFragments()) != null) {
                    for (Bundle fragment : fragments) {
                        Document description2 = fragment.getDescription();
                        if (description2 == null) continue;
                        Comment comment = document.createComment("import from " + fragment.getBundleID());
                        document.getDocumentElement().appendChild(comment);
                        this.appendDescription(document, description2);
                    }
                }
                if ((description = bundle.getDescription()) == null) continue;
                Comment comment = document.createComment("import from " + bundle.getBundleID());
                document.getDocumentElement().appendChild(comment);
                this.appendDescription(document, description);
            }
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(zipOutput);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        finally {
            zipOutput.closeEntry();
        }
    }

    protected void appendDescription(Document tgt, Document src) {
        Element tgtRoot = tgt.getDocumentElement();
        Element srcRoot = src.getDocumentElement();
        NodeList nodes = srcRoot.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = tgt.importNode(nodes.item(i), true);
            tgtRoot.appendChild(node);
            ++i;
        }
    }

    protected void packBundle(ZipOutputStream output, Bundle bundle) throws IOException {
        BundleFile bundleFile = bundle.getBundleFile();
        Filter filter = this.filters.get(bundle.getBundleID());
        List<String> pathes = bundleFile.getEntryPaths("/");
        for (String path : pathes) {
            this.packBundle(output, bundle, path, filter);
        }
    }

    protected File createTempFile(BundleEntry entry) throws IOException {
        File tmpFile = File.createTempFile("zip", ".zip");
        FileOutputStream output = new FileOutputStream(tmpFile);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            try (InputStream input = entry.getInputStream();){
                this.copyStream(input, output);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tmpFile;
    }

    protected void packBundle(ZipOutputStream output, Bundle bundle, String path, Filter filter) throws IOException {
        if (filter != null && !filter.accept(path)) {
            this.log(Level.FINE, "exclude {0}/{1}", new Object[]{bundle.getBundleID(), path});
            return;
        }
        BundleFile bundleFile = bundle.getBundleFile();
        if (bundleFile.isDirectory(path)) {
            List<String> entries = bundleFile.getEntryPaths(path);
            for (String entry : entries) {
                this.packBundle(output, bundle, entry, filter);
            }
            return;
        }
        BundleEntry bundleEntry = bundleFile.getEntry(path);
        if (path.endsWith(".jar") || path.endsWith(".zip")) {
            File tempZipFile = this.createTempFile(bundleEntry);
            try (ZipFile zipFile = new ZipFile(tempZipFile);){
                this.packZip(output, bundleEntry, zipFile, filter);
            }
            finally {
                tempZipFile.delete();
            }
            return;
        }
        if (this.existingEntries.contains(path)) {
            this.log(Level.WARNING, "duplicate {0}/{1}", new Object[]{bundle.getBundleID(), path});
            return;
        }
        this.existingEntries.add(path);
        InputStream input = bundleEntry.getInputStream();
        Throwable throwable = null;
        Object var9_16 = null;
        try {
            try {
                ZipEntry zipEntry = new ZipEntry(bundleEntry.getName());
                zipEntry.setTime(bundleEntry.getTime());
                zipEntry.setSize(bundleEntry.getSize());
                output.putNextEntry(zipEntry);
                try {
                    this.copyStream(input, output);
                }
                finally {
                    output.closeEntry();
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void packZip(ZipOutputStream output, BundleEntry bundleEntry, ZipFile zipFile, Filter filter) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry srcEntry = entries.nextElement();
            String entryName = srcEntry.getName();
            if (filter != null && !filter.accept(String.valueOf(bundleEntry.getName()) + "/" + entryName)) {
                this.log(Level.FINE, "exclude {0}/{1}/{2}", new Object[]{bundleEntry.getBundleID(), bundleEntry.getName(), entryName});
                continue;
            }
            if (entryName.endsWith("/")) continue;
            if (this.existingEntries.contains(entryName)) {
                this.log(Level.WARNING, "duplicate {0}/{1}/{2}", new Object[]{bundleEntry.getBundleID(), bundleEntry.getName(), entryName});
                continue;
            }
            this.existingEntries.add(entryName);
            ZipEntry tgtEntry = new ZipEntry(entryName);
            tgtEntry.setTime(srcEntry.getTime());
            output.putNextEntry(tgtEntry);
            try {
                InputStream input = zipFile.getInputStream(srcEntry);
                Throwable throwable = null;
                Object var11_12 = null;
                try {
                    try {
                        this.copyStream(input, output);
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                output.closeEntry();
            }
        }
    }

    protected void copyStream(InputStream src, OutputStream tgt) throws IOException {
        byte[] buffer = new byte[4096];
        int size = src.read(buffer);
        while (size > 0) {
            tgt.write(buffer, 0, size);
            size = src.read(buffer);
        }
    }

    protected void log(Level level, String message) {
        logger.log(level, message);
    }

    protected void log(Level level, String message, Object[] params) {
        logger.log(level, message, params);
    }

    protected void log(Level level, String message, Object[] params, Throwable cause) {
        if (logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, message);
            record.setParameters(params);
            record.setThrown(cause);
            logger.log(record);
        }
    }
}

