/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.mavenrepogen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.birt.build.mavenrepogen.ExternalDependency;
import org.eclipse.birt.build.mavenrepogen.FileInfo;

public class RepoGen {
    private final File libDir;
    private final String groupId;
    private final String passphrase;
    private final File repoDir;
    private final File groupDir;
    private final File globalSnapshotBuildFile;
    private final File globalSnapshotScriptFile;
    private final File globalReleaseBuildFile;
    private final File globalReleaseScriptFile;
    private final File templateSnapshotPomFile;
    private final File templateReleasePomFile;
    private final String rootFileName;
    private final File readmeFile;
    private final File sourceDir;
    private final String externalFileName = "./externalRepo.properties";
    private final Map<String, ExternalDependency> externalDependencies;

    private RepoGen(File libDir, File repoParentDir, String groupId, String passphrase, boolean snapshot, boolean release, boolean clean, String rootFileName, String readmeFilePath, File sourceDir) throws IOException {
        this.libDir = libDir;
        this.groupId = groupId;
        this.passphrase = passphrase;
        this.readmeFile = new File(readmeFilePath);
        this.sourceDir = sourceDir;
        this.repoDir = new File(repoParentDir, "repository");
        this.repoDir.mkdir();
        this.groupDir = new File(this.repoDir, groupId);
        if (clean) {
            this.deepDelete(this.groupDir);
        }
        this.groupDir.mkdir();
        if (snapshot) {
            this.globalSnapshotBuildFile = new File(this.groupDir, "buildSnapshot.xml");
            this.globalSnapshotBuildFile.createNewFile();
            this.globalSnapshotScriptFile = new File(this.groupDir, "buildSnapshot.sh");
            this.globalSnapshotScriptFile.createNewFile();
            this.templateSnapshotPomFile = new File(this.groupDir, "templateSnapshotPomFile.xml");
            this.templateSnapshotPomFile.createNewFile();
        } else {
            this.globalSnapshotBuildFile = null;
            this.globalSnapshotScriptFile = null;
            this.templateSnapshotPomFile = null;
        }
        if (release) {
            this.globalReleaseBuildFile = new File(this.groupDir, "buildRelease.xml");
            this.globalReleaseBuildFile.createNewFile();
            this.globalReleaseScriptFile = new File(this.groupDir, "buildRelease.sh");
            this.globalReleaseScriptFile.createNewFile();
            this.templateReleasePomFile = new File(this.groupDir, "templateReleasePomFile.xml");
            this.templateReleasePomFile.createNewFile();
        } else {
            this.globalReleaseBuildFile = null;
            this.globalReleaseScriptFile = null;
            this.templateReleasePomFile = null;
        }
        this.rootFileName = rootFileName;
        this.externalDependencies = new HashMap<String, ExternalDependency>();
        this.readExternalDependency();
        System.out.println(String.valueOf(this.externalDependencies.size()) + " external dependencies found.");
    }

    private void addExternalDependency(String fileName, String groupId, String artifactId, String version) {
        this.externalDependencies.put(fileName, new ExternalDependency(fileName, groupId, artifactId, version));
    }

    public static void main(String[] args) throws IOException {
        String propsFileName = args.length >= 1 ? args[0] : "./repoGen.properties";
        String passphrase = null;
        if (args.length >= 2) {
            passphrase = args[1];
        }
        Properties properties = new Properties();
        FileReader fr = new FileReader(propsFileName);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            try {
                properties.load(fr);
            }
            finally {
                if (fr != null) {
                    fr.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String libDirName = properties.getProperty("libDir");
        String repoDirName = properties.getProperty("repoDir");
        String groupId = properties.getProperty("groupId");
        if (passphrase == null) {
            passphrase = properties.getProperty("passphrase");
        }
        boolean clean = "true".equalsIgnoreCase(properties.getProperty("clean"));
        boolean genSnapshot = "true".equalsIgnoreCase(properties.getProperty("snapshot"));
        boolean genRelease = "true".equalsIgnoreCase(properties.getProperty("release"));
        String rootFileName = properties.getProperty("rootFile");
        String readmeFilePath = properties.getProperty("readmeFile");
        String sourceDir = properties.getProperty("sourceDir");
        RepoGen repoGen = new RepoGen(new File(libDirName), new File(repoDirName), groupId, passphrase, genSnapshot, genRelease, clean, rootFileName, readmeFilePath, new File(sourceDir));
        repoGen.generate();
    }

    private void generate() throws IOException {
        PrintWriter globalReleaseBuildFileWriter;
        PrintWriter globalSnapshotBuildFileWriter = this.createGlobalBuildFileWriter(this.globalSnapshotBuildFile, "deploy");
        PrintWriter globalSnapshotScriptFileWriter = this.createGlobalScriptFileWriter(this.globalSnapshotScriptFile);
        if (this.globalReleaseBuildFile != null) {
            globalReleaseBuildFileWriter = new PrintWriter(new FileWriter(this.globalReleaseBuildFile));
            globalReleaseBuildFileWriter.print("<project name=\"");
            globalReleaseBuildFileWriter.print(this.groupId);
            globalReleaseBuildFileWriter.println("\" default=\"stage\" basedir=\".\" xmlns:artifact=\"antlib:org.apache.maven.artifact.ant\">");
            globalReleaseBuildFileWriter.println(" <target name=\"stage\">");
        } else {
            globalReleaseBuildFileWriter = null;
        }
        PrintWriter globalReleaseScriptFileWriter = this.createGlobalScriptFileWriter(this.globalReleaseScriptFile);
        PrintWriter templateSnapshotPomWriter = this.createTemplatePomWriter(this.templateSnapshotPomFile, true);
        PrintWriter templateReleasePomWriter = this.createTemplatePomWriter(this.templateReleasePomFile, false);
        File rootFile = null;
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        File[] files = this.libDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileInfo fileInfo;
                File file = fileArray[n2];
                if (this.rootFileName != null && this.rootFileName.equals(file.getName())) {
                    rootFile = file;
                } else if (!this.externalDependencies.containsKey(file.getName()) && (fileInfo = this.getFileInfo(file)) != null) {
                    fileInfos.add(fileInfo);
                    this.generateFile(fileInfo, true, globalSnapshotBuildFileWriter, globalSnapshotScriptFileWriter, templateSnapshotPomWriter, null, null);
                    this.generateFile(fileInfo, false, globalReleaseBuildFileWriter, globalReleaseScriptFileWriter, templateReleasePomWriter, null, null);
                }
                ++n2;
            }
        }
        if (rootFile != null) {
            FileInfo fileInfo = this.getFileInfo(rootFile);
            this.generateFile(fileInfo, true, globalSnapshotBuildFileWriter, globalSnapshotScriptFileWriter, templateSnapshotPomWriter, fileInfos, this.externalDependencies.values());
            this.generateFile(fileInfo, false, globalReleaseBuildFileWriter, globalReleaseScriptFileWriter, templateReleasePomWriter, fileInfos, this.externalDependencies.values());
        }
        int tmpCount = fileInfos.size() + 1;
        System.out.println(String.valueOf(tmpCount) + " jars under runtime lib folder founded.");
        this.closeTemplatePomWriter(templateSnapshotPomWriter);
        this.closeTemplatePomWriter(templateReleasePomWriter);
        this.closeBuildFileWriter(globalSnapshotBuildFileWriter);
        this.closeBuildFileWriter(globalReleaseBuildFileWriter);
        this.closeScriptFileWriter(globalSnapshotScriptFileWriter);
        this.closeScriptFileWriter(globalReleaseScriptFileWriter);
    }

    private PrintWriter createGlobalScriptFileWriter(File file) throws IOException {
        if (file == null) {
            return null;
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("# Execute all the builds.");
        writer.println("export ANT_OPTS=\"-XX:MaxPermSize=256m\"");
        writer.println("date > time.log");
        return writer;
    }

    private void closeBuildFileWriter(PrintWriter writer) {
        if (writer != null) {
            writer.println(" </target>");
            writer.println("</project>");
            writer.close();
        }
    }

    private void closeScriptFileWriter(PrintWriter writer) {
        if (writer != null) {
            writer.println("# done.");
            writer.println("date >> time.log");
            writer.close();
        }
    }

    private void closeTemplatePomWriter(PrintWriter writer) {
        if (writer != null) {
            for (ExternalDependency externalDependency : this.externalDependencies.values()) {
                writer.println("   <dependency>");
                writer.print("    <groupId>");
                writer.print(externalDependency.getGroupId());
                writer.println("</groupId>");
                writer.print("     <artifactId>");
                writer.print(externalDependency.getArtifactId());
                writer.println("</artifactId>");
                writer.print("     <version>");
                writer.print(externalDependency.getVersion());
                writer.println("</version>");
                writer.println("   </dependency>");
            }
            writer.println(" </dependencies>");
            writer.println("</project>");
            writer.close();
        }
    }

    private PrintWriter createGlobalBuildFileWriter(File file, String string) throws IOException {
        if (file == null) {
            return null;
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.print("<project name=\"");
        writer.print(this.groupId);
        writer.print("\" default=\"");
        writer.print("string");
        writer.print("\" basedir=\".\" xmlns:artifact=\"antlib:org.apache.maven.artifact.ant\">");
        writer.print(" <target name=\"");
        writer.print("string");
        writer.println("\">");
        return writer;
    }

    private PrintWriter createTemplatePomWriter(File file, boolean snapshot) throws IOException {
        if (file == null) {
            return null;
        }
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<project");
        writer.println(" xmlns=\"http://maven.apache.org/POM/4.0.0\"");
        writer.println(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        writer.println(" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">");
        writer.println(" <modelVersion>4.0.0</modelVersion>");
        writer.println(" <repositories>");
        writer.println("  <repository>");
        if (snapshot) {
            writer.println("   <id>sonatype-nexus-snapshots</id>");
            writer.println("   <name>Sonatype Nexus Snapshots</name>");
            writer.println("   <url>https://oss.sonatype.org/content/repositories/snapshots/</url>");
        } else {
            writer.println("   <id>sonatype-nexus-staging</id>");
            writer.println("   <name>Sonatype Nexus Staging</name>");
            writer.println("   <url>https://oss.sonatype.org/service/local/staging/deploy/maven2/</url>");
        }
        writer.println("  </repository>");
        writer.println(" </repositories>");
        writer.println(" <dependencies>");
        return writer;
    }

    private FileInfo getFileInfo(File file) throws IOException {
        String version;
        String artifactId;
        if (file.isDirectory() || !file.getAbsolutePath().toLowerCase().endsWith(".jar")) {
            return null;
        }
        System.out.println(file);
        Manifest manifest = this.getManifest(file);
        if (manifest == null) {
            artifactId = file.getName();
            int indexOfDot = artifactId.lastIndexOf(".");
            if (indexOfDot >= 0) {
                artifactId = artifactId.substring(0, indexOfDot);
            }
            version = "1";
        } else {
            Attributes mainAttributes = manifest.getMainAttributes();
            artifactId = mainAttributes.getValue("Bundle-SymbolicName");
            if (artifactId != null) {
                int indexofsemicolon = artifactId.indexOf(";");
                if (indexofsemicolon >= 0) {
                    artifactId = artifactId.substring(0, indexofsemicolon);
                }
                version = mainAttributes.getValue("Bundle-Version");
                if (file.getName().equals(this.rootFileName)) {
                    version = this.trimVersion(version);
                    System.out.println("root file found: " + this.rootFileName + ", version: " + version);
                }
            } else {
                artifactId = mainAttributes.getValue("Specification-Title");
                if (artifactId != null) {
                    version = mainAttributes.getValue("Specification-Version");
                } else {
                    artifactId = file.getName();
                    int indexOfDot = artifactId.lastIndexOf(".");
                    if (indexOfDot >= 0) {
                        artifactId = artifactId.substring(0, indexOfDot);
                    }
                    version = "1";
                }
            }
        }
        return new FileInfo(file, this.groupId, artifactId, version);
    }

    private void generateFile(FileInfo fileInfo, boolean snapshot, PrintWriter globalBuildFileWriter, PrintWriter globalScriptFileWriter, PrintWriter templatePomFileWriter, List<FileInfo> dependsOn, Collection<ExternalDependency> externalDependencies) throws IOException {
        if (globalBuildFileWriter == null || templatePomFileWriter == null) {
            return;
        }
        File projectDir = new File(this.groupDir, fileInfo.getArtifactId());
        projectDir.mkdir();
        File versionDir = new File(projectDir, fileInfo.getVersion(snapshot));
        this.deepDelete(versionDir);
        versionDir.mkdir();
        String newFileName = String.valueOf(fileInfo.getArtifactId()) + "-" + fileInfo.getVersion(snapshot);
        File jarFile = new File(versionDir, String.valueOf(newFileName) + ".jar");
        this.copy(fileInfo.getFile(), jarFile);
        File pomFile = new File(versionDir, String.valueOf(newFileName) + ".pom");
        File sourceFileTarget = new File(versionDir, String.valueOf(fileInfo.getArtifactId()) + "-" + fileInfo.getVersion(snapshot) + "-sources.jar");
        File sourceFileSource = new File(this.sourceDir, String.valueOf(fileInfo.getArtifactId()) + "-" + fileInfo.getVersion() + "-sources.jar");
        File javadocFile = new File(versionDir, String.valueOf(fileInfo.getArtifactId()) + "-" + fileInfo.getVersion(snapshot) + "-javadoc.jar");
        if (sourceFileSource.exists()) {
            this.createJar(sourceFileTarget, sourceFileSource);
        } else {
            System.out.println("Creating fake source bundles for " + fileInfo.getArtifactId());
            this.createJar(sourceFileTarget, new File[]{this.readmeFile});
        }
        this.createJar(javadocFile, new File[]{this.readmeFile});
        this.createPomFile(fileInfo, snapshot, pomFile, dependsOn, externalDependencies);
        this.createAntFile(new File(versionDir, "build.xml"), pomFile, fileInfo.getArtifactId(), jarFile, snapshot, sourceFileTarget, javadocFile);
        globalScriptFileWriter.println("#");
        globalScriptFileWriter.print("pushd ");
        globalScriptFileWriter.println(versionDir);
        globalScriptFileWriter.println("$ANT_HOME/bin/ant --noconfig");
        globalScriptFileWriter.println("popd");
        globalBuildFileWriter.print("  <ant dir=\"");
        globalBuildFileWriter.print(versionDir);
        globalBuildFileWriter.print("\" target=\"");
        globalBuildFileWriter.print(snapshot ? "deploy" : "stage");
        globalBuildFileWriter.println("\" inheritAll=\"false\"/>");
        this.exec(new String[]{"/usr/bin/gpg", "-ab", "--batch", "--passphrase", this.passphrase, pomFile.getName()}, versionDir);
        this.exec(new String[]{"/usr/bin/gpg", "-ab", "--batch", "--passphrase", this.passphrase, jarFile.getName()}, versionDir);
        this.exec(new String[]{"/usr/bin/gpg", "-ab", "--batch", "--passphrase", this.passphrase, sourceFileTarget.getName()}, versionDir);
        this.exec(new String[]{"/usr/bin/gpg", "-ab", "--batch", "--passphrase", this.passphrase, javadocFile.getName()}, versionDir);
        this.createJar(new File(versionDir, "bundle.jar"), new File[]{pomFile, jarFile, javadocFile, sourceFileTarget, new File(String.valueOf(pomFile.getAbsolutePath()) + ".asc"), new File(String.valueOf(jarFile.getAbsolutePath()) + ".asc"), new File(String.valueOf(javadocFile.getAbsolutePath()) + ".asc"), new File(String.valueOf(sourceFileTarget.getAbsolutePath()) + ".asc")});
        templatePomFileWriter.println("   <dependency>");
        templatePomFileWriter.print("    <groupId>");
        templatePomFileWriter.print(this.groupId);
        templatePomFileWriter.println("</groupId>");
        templatePomFileWriter.print("     <artifactId>");
        templatePomFileWriter.print(fileInfo.getArtifactId());
        templatePomFileWriter.println("</artifactId>");
        templatePomFileWriter.print("     <version>");
        templatePomFileWriter.print(fileInfo.getVersion(snapshot));
        templatePomFileWriter.println("</version>");
        templatePomFileWriter.println("   </dependency>");
    }

    /*
     * Unable to fully structure code
     */
    private Manifest getManifest(File file) throws IOException {
        zis = new ZipInputStream(new FileInputStream(file));
        var3_3 = null;
        var4_5 = null;
        try {
            try {
                entry = zis.getNextEntry();
                while (true) {
                    if ("META-INF/MANIFEST.MF".equals(entry.getName())) {
                        return new Manifest(zis);
                    }
                    entry = zis.getNextEntry();
                    return entry;
                }
            }
            finally {
                if (entry != null) ** continue;
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
            } else if (var3_3 != var4_6) {
                var3_3.addSuppressed(var4_6);
            }
            throw var3_3;
        }
        return null;
    }

    private void createPomFile(FileInfo fileInfo, boolean snapshot, File pomFile, List<FileInfo> dependsOn, Collection<ExternalDependency> externalDependencies) throws IOException {
        String artifactName = fileInfo.getFile().getName();
        PrintWriter pw = new PrintWriter(new FileWriter(pomFile));
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            try {
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.print("<project");
                pw.print(" xsi:schemaLocation=\"");
                pw.print("http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
                pw.print("\" xmlns=\"");
                pw.print("http://maven.apache.org/POM/4.0.0");
                pw.print("\" xmlns:xsi=\"");
                pw.print("http://www.w3.org/2001/XMLSchema-instance");
                pw.println("\">");
                pw.println("  <parent>");
                pw.println("    <groupId>org.sonatype.oss</groupId>");
                pw.println("    <artifactId>oss-parent</artifactId>");
                pw.println("    <version>7</version>");
                pw.println("  </parent>");
                pw.println("  <modelVersion>4.0.0</modelVersion>");
                pw.print("  <groupId>");
                pw.print(this.groupId);
                pw.println("</groupId>");
                pw.print("  <artifactId>");
                pw.print(fileInfo.getArtifactId());
                pw.println("</artifactId>");
                pw.print("  <version>");
                pw.print(fileInfo.getVersion(snapshot));
                pw.println("</version>");
                pw.println("  <packaging>jar</packaging>");
                pw.print("  <name>");
                pw.print(artifactName);
                pw.println("</name>");
                pw.println("  <description>A component of the BIRT runtime</description>");
                pw.println("  <url>http://www.eclipse.org/projects/project.php?id=birt</url>");
                pw.println("  <licenses>");
                pw.println("    <license>");
                pw.println("      <name>Eclipse Public License - v 2.0</name>");
                pw.println("      <url>https://www.eclipse.org/legal/epl-2.0.html</url>");
                pw.println("    </license>");
                pw.println("  </licenses>");
                pw.println("  <scm>");
                pw.println("    <url>http://git.eclipse.org/c/birt/org.eclipse.birt.git/</url>");
                pw.println("    <connection>http://git.eclipse.org/c/birt/org.eclipse.birt.git/</connection>");
                pw.println("  </scm>");
                pw.println("  <developers></developers>");
                if (dependsOn != null || externalDependencies != null) {
                    pw.println("  <dependencies>");
                    if (dependsOn != null) {
                        for (FileInfo childFileInfo : dependsOn) {
                            pw.println("    <dependency>");
                            pw.print("      <groupId>");
                            pw.print(childFileInfo.getGroupId());
                            pw.println("</groupId>");
                            pw.print("       <artifactId>");
                            pw.print(childFileInfo.getArtifactId());
                            pw.println("</artifactId>");
                            pw.print("       <version>");
                            pw.print(childFileInfo.getVersion(snapshot));
                            pw.println("</version>");
                            pw.println("    </dependency>");
                        }
                    }
                    if (externalDependencies != null) {
                        for (ExternalDependency externalDependency : externalDependencies) {
                            pw.println("    <dependency>");
                            pw.print("      <groupId>");
                            pw.print(externalDependency.getGroupId());
                            pw.println("</groupId>");
                            pw.print("       <artifactId>");
                            pw.print(externalDependency.getArtifactId());
                            pw.println("</artifactId>");
                            pw.print("       <version>");
                            pw.print(externalDependency.getVersion());
                            pw.println("</version>");
                            pw.println("    </dependency>");
                        }
                    }
                    pw.println("  </dependencies>");
                }
                pw.println("</project>");
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createAntFile(File antFile, File pomFile, String artifactId, File jarFile, boolean snapshot, File sourceFile, File javadocFile) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(antFile));
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            try {
                pw.print("<project name=\"");
                pw.print(artifactId);
                pw.print("\" default=\"");
                pw.print(snapshot ? "deploy" : "stage");
                pw.println("\" basedir=\".\" xmlns:artifact=\"antlib:org.apache.maven.artifact.ant\">");
                if (snapshot) {
                    pw.println(" <property name=\"maven-snapshots-repository-id\" value=\"sonatype-nexus-snapshots\"/>");
                    pw.println(" <property name=\"maven-snapshots-repository-url\" value=\"https://oss.sonatype.org/content/repositories/snapshots\"/>");
                    pw.println(" <target name=\"deploy\">");
                    pw.println("  <artifact:mvn>");
                    pw.println("   <arg value=\"org.apache.maven.plugins:maven-deploy-plugin:2.6:deploy-file\"/>");
                    pw.println("   <arg value=\"-Durl=${maven-snapshots-repository-url}\"/>");
                    pw.println("   <arg value=\"-DrepositoryId=${maven-snapshots-repository-id}\"/>");
                    pw.print("   <arg value=\"-DpomFile=");
                    pw.print(pomFile);
                    pw.println("\"/>");
                    pw.print("   <arg value=\"-Dfile=");
                    pw.print(jarFile);
                    pw.println("\"/>");
                    pw.println("  </artifact:mvn>");
                    pw.println(" </target>");
                } else {
                    pw.println(" <property name=\"maven-staging-repository-id\" value=\"sonatype-nexus-staging\" />");
                    pw.println(" <property name=\"maven-staging-repository-url\" value=\"https://oss.sonatype.org/service/local/staging/deploy/maven2/\" />");
                    pw.println(" <target name=\"stage\">");
                    pw.println("  <artifact:mvn>");
                    pw.println("   <arg value=\"org.apache.maven.plugins:maven-gpg-plugin:1.3:sign-and-deploy-file\" />");
                    pw.println("   <arg value=\"-Durl=${maven-staging-repository-url}\" />");
                    pw.println("   <arg value=\"-DrepositoryId=${maven-staging-repository-id}\" />");
                    pw.print("   <arg value=\"-DpomFile=");
                    pw.print(pomFile);
                    pw.println("\"/>");
                    pw.print("   <arg value=\"-Dfile=");
                    pw.print(jarFile);
                    pw.println("\"/>");
                    pw.println("   <arg value=\"-Pgpg\"/>");
                    pw.println("  </artifact:mvn>");
                    pw.println("");
                    pw.println("  <!-- deploy source jars -->");
                    pw.println("  <artifact:mvn>");
                    pw.println("   <arg value=\"org.apache.maven.plugins:maven-gpg-plugin:1.3:sign-and-deploy-file\" />");
                    pw.println("   <arg value=\"-Durl=${maven-staging-repository-url}\"/>");
                    pw.println("   <arg value=\"-DrepositoryId=${maven-staging-repository-id}\"/>");
                    pw.print("   <arg value=\"-DpomFile=");
                    pw.print(pomFile);
                    pw.println("\"/>");
                    pw.print("   <arg value=\"-Dfile=");
                    pw.print(sourceFile);
                    pw.println("\"/>");
                    pw.println("   <arg value=\"-Dclassifier=sources\"/>");
                    pw.println("   <arg value=\"-Pgpg\"/>");
                    pw.println("  </artifact:mvn>");
                    pw.println("");
                    pw.println("  <!-- deploy javadoc jars -->");
                    pw.println("  <artifact:mvn>");
                    pw.println("   <arg value=\"org.apache.maven.plugins:maven-gpg-plugin:1.3:sign-and-deploy-file\" />");
                    pw.println("   <arg value=\"-Durl=${maven-staging-repository-url}\"/>");
                    pw.println("   <arg value=\"-DrepositoryId=${maven-staging-repository-id}\"/>");
                    pw.print("   <arg value=\"-DpomFile=");
                    pw.print(pomFile);
                    pw.println("\"/>");
                    pw.print("   <arg value=\"-Dfile=");
                    pw.print(javadocFile);
                    pw.println("\"/>");
                    pw.println("   <arg value=\"-Dclassifier=javadoc\"/>");
                    pw.println("   <arg value=\"-Pgpg\"/>");
                    pw.println("  </artifact:mvn>");
                    pw.println(" </target>");
                }
                pw.println("</project>");
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createJar(File jarFile, File[] files) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Created-By", "RepoGen 1.0.0");
        FileOutputStream fos = new FileOutputStream(jarFile);
        JarOutputStream jos = new JarOutputStream((OutputStream)fos, manifest);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ZipEntry entry = new ZipEntry(file.getName());
            jos.putNextEntry(entry);
            FileInputStream fis = new FileInputStream(file);
            this.pipeStream(fis, jos);
            fis.close();
            ++n2;
        }
        jos.close();
    }

    private void createJar(File jarTargetFile, File jarSourceFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(jarTargetFile);
        FileInputStream fis = new FileInputStream(jarSourceFile);
        this.pipeStream(fis, fos);
        fis.close();
        fos.close();
    }

    private void exec(String[] command, File dir) throws IOException {
        Process process = Runtime.getRuntime().exec(command, null, dir);
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (process.exitValue() != 0) {
            System.out.println(command + " failed:");
            System.out.println("error stream:");
            this.pipeStream(process.getErrorStream(), System.out);
            System.out.println("output stream:");
            this.pipeStream(process.getInputStream(), System.out);
        }
    }

    private void pipeStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[4096];
        int bytesRead = inputStream.read(buffer);
        while (bytesRead >= 0) {
            outputStream.write(buffer, 0, bytesRead);
            bytesRead = inputStream.read(buffer);
        }
        inputStream.close();
    }

    private void deepDelete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.deepDelete(file.listFiles());
        }
        file.delete();
    }

    private void deepDelete(File[] files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.deepDelete(file);
            ++n2;
        }
    }

    private void readExternalDependency() throws IOException {
        File file = new File("./externalRepo.properties");
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        String temp = br.readLine();
        while (temp != null) {
            if (temp.startsWith("#") || temp.trim().equals("")) {
                temp = br.readLine();
                continue;
            }
            String[] exValue = temp.split(",");
            this.addExternalDependency(exValue[0].trim(), exValue[1].trim(), exValue[2].trim(), exValue[3].trim());
            System.out.println("Adding External Dependency: " + exValue[0]);
            temp = br.readLine();
        }
    }

    private String trimVersion(String version) {
        if (version == null) {
            return "1";
        }
        String[] parts = version.split("\\.");
        StringBuilder sb = new StringBuilder();
        String sep = "";
        int i = 0;
        while (i < parts.length && i < 3) {
            String part = parts[i];
            sb.append(sep);
            sep = ".";
            sb.append(part);
            ++i;
        }
        return sb.toString();
    }

    private void copy(File sourceFile, File destinationFile) throws IOException {
        destinationFile.createNewFile();
        FileInputStream fis = new FileInputStream(sourceFile);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            try (FileOutputStream fos = new FileOutputStream(destinationFile);){
                byte[] buffer = new byte[16384];
                int bytesRead = fis.read(buffer);
                while (bytesRead >= 0) {
                    fos.write(buffer, 0, bytesRead);
                    bytesRead = fis.read(buffer);
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

