/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.build.framework.BundleEntry;
import org.eclipse.birt.build.framework.BundleFile;
import org.eclipse.birt.build.framework.FileBundleFile;
import org.eclipse.birt.build.framework.FrameworkException;
import org.eclipse.birt.build.framework.ZipBundleFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Bundle {
    protected BundleFile bundleFile;
    protected boolean fragment;
    protected String bundleID;
    protected String hostID;
    protected Document description;
    protected ArrayList<Bundle> fragments;

    public Bundle(File file) throws FrameworkException {
        try {
            this.bundleFile = file.isDirectory() ? new FileBundleFile(this, file) : new ZipBundleFile(this, file);
            this.loadBundle();
        }
        catch (Exception ex) {
            this.close();
            throw new FrameworkException(ex);
        }
    }

    public void close() {
        if (this.bundleFile != null) {
            try {
                this.bundleFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bundleFile = null;
        }
    }

    public BundleFile getBundleFile() {
        return this.bundleFile;
    }

    public List<Bundle> getFragments() {
        if (this.fragments == null || this.fragments.isEmpty()) {
            return null;
        }
        return this.fragments;
    }

    public void addFragment(Bundle bundle) {
        if (this.isFragment()) {
            throw new UnsupportedOperationException("only host bundle can be attached with fragment");
        }
        if (!bundle.isFragment()) {
            throw new UnsupportedOperationException("only fragment can be attached to the host bundle");
        }
        if (this.fragments == null) {
            this.fragments = new ArrayList();
        }
        this.fragments.add(bundle);
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public String getHostID() {
        return this.hostID;
    }

    public String getBundleID() {
        return this.bundleID;
    }

    public Document getDescription() {
        return this.description;
    }

    protected void loadBundle() throws IOException, ParserConfigurationException, SAXException {
        String fragmentHost;
        String patchFragment;
        String symbolicName;
        Manifest manifest = this.loadManifest();
        Attributes mainAttrs = manifest.getMainAttributes();
        String propertyFile = mainAttrs.getValue("Bundle-Localization");
        Properties properties = null;
        if (propertyFile != null) {
            properties = this.loadProperties(String.valueOf(propertyFile) + ".properties");
        }
        if ((symbolicName = mainAttrs.getValue("Bundle-SymbolicName")) != null) {
            this.bundleID = this.getSymbolicName(symbolicName);
        }
        if ("true".equals(patchFragment = mainAttrs.getValue("Eclipse-PatchFragment"))) {
            this.fragment = true;
        }
        if ((fragmentHost = mainAttrs.getValue("Fragment-Host")) != null) {
            this.hostID = this.getSymbolicName(fragmentHost);
        }
        this.description = this.loadDescription("plugin.xml");
        if (this.description != null) {
            if (properties != null) {
                this.localizeDocument(this.description, properties);
            }
            this.normalizeExtension(this.bundleID, this.description);
        }
    }

    private String getSymbolicName(String symbolicName) {
        int charPos;
        if (symbolicName != null && (charPos = symbolicName.indexOf(";")) != -1) {
            return symbolicName.substring(0, charPos);
        }
        return symbolicName;
    }

    private Manifest loadManifest() throws IOException {
        InputStream in;
        BundleEntry entry = this.bundleFile.getEntry("/META-INF/MANIFEST.MF");
        if (entry != null && (in = entry.getInputStream()) != null) {
            try {
                Manifest manifest;
                Manifest manifest2 = manifest = new Manifest(in);
                return manifest2;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private Properties loadProperties(String path) throws IOException {
        InputStream in;
        BundleEntry entry = this.bundleFile.getEntry(path);
        if (entry != null && (in = entry.getInputStream()) != null) {
            try {
                Properties properties = new Properties();
                properties.load(in);
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private Document loadDescription(String path) throws IOException, ParserConfigurationException, SAXException {
        InputStream in;
        BundleEntry entry = this.bundleFile.getEntry(path);
        if (entry != null && (in = entry.getInputStream()) != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in, path);
            return document;
        }
        return null;
    }

    private void localizeDocument(Document document, Properties properties) {
        Element documentElement = document.getDocumentElement();
        this.localizeElement(documentElement, properties);
    }

    private void normalizeExtension(String bundleId, Document document) {
        Element documentElement = document.getDocumentElement();
        NodeList nodes = documentElement.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            String id;
            Element element;
            String name;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && ("extension".equals(name = (element = (Element)node).getTagName()) || "extension-point".equals(name)) && (id = element.getAttribute("id")) != null && id.length() > 0 && id.indexOf(46) == -1) {
                id = String.valueOf(bundleId) + '.' + id;
                element.setAttribute("id", id);
            }
            ++i;
        }
    }

    private void localizeElement(Element element, Properties properties) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            String localizedValue;
            String value;
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 2 && (value = attribute.getNodeValue()) != null && !value.equals(localizedValue = this.localize(value, properties))) {
                attribute.setNodeValue(localizedValue);
            }
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                this.localizeElement((Element)child, properties);
            }
            ++i2;
        }
    }

    private String localize(String value, Properties properties) {
        String key;
        String localizedValue;
        if (value != null && value.length() > 1 && value.charAt(0) == '%' && (localizedValue = properties.getProperty(key = value.substring(1))) != null) {
            return localizedValue;
        }
        return value;
    }
}

