/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Manifest;
import org.eclipse.birt.build.ant.BundleItem;
import org.eclipse.birt.build.ant.FilterItem;
import org.eclipse.birt.build.framework.Bundle;
import org.eclipse.birt.build.framework.Framework;
import org.eclipse.birt.build.framework.FrameworkException;
import org.eclipse.birt.build.pack.Filter;
import org.eclipse.birt.build.pack.FrameworkPacker;

public class PackTask
extends Task {
    private String baseDir;
    private String output;
    private Manifest manifest;
    private ArrayList<BundleItem> bundleItems = new ArrayList();
    private static Filter DEFAULT_FILTER = new Filter(new String[0], new String[]{"plugin\\..*", "fragment\\..*", "(.*\\.jar/)?META-INF/MANIFEST\\.MF", "(.*\\.jar/)?META-INF/ECLIPSEF\\..*", "(.*\\.jar/)?META-INF/eclipse\\.inf", "about\\..*", "about_files/.*"});

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public Object createBundle() {
        BundleItem bundle = new BundleItem();
        this.bundleItems.add(bundle);
        return bundle;
    }

    public void addManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public void execute() throws BuildException {
        block23: {
            this.log("create " + this.output + " from " + this.baseDir, 2);
            Framework framework = new Framework();
            FrameworkPacker packer = new FrameworkPacker(framework);
            try {
                try {
                    if (this.bundleItems.isEmpty()) {
                        this.bundleItems.addAll(this.loadBundleItems(this.baseDir));
                    }
                    if (this.bundleItems.isEmpty()) {
                        throw new BuildException("failed to load bundle from directory:" + this.baseDir);
                    }
                    for (BundleItem bundleItem : this.bundleItems) {
                        String bundleName = bundleItem.getName();
                        File bundleFile = this.getFile(this.baseDir, bundleName);
                        if (bundleFile != null) {
                            try {
                                this.log("load bundle " + bundleName + " from " + bundleFile.getName(), 2);
                                Bundle bundle = framework.addBundle(bundleFile);
                                Filter filter = this.createFilter(bundleItem);
                                packer.setFilter(bundle.getBundleID(), filter);
                            }
                            catch (FrameworkException ex) {
                                this.log("failed to load the bundle" + bundleName, ex, 1);
                            }
                            continue;
                        }
                        this.log("can't find bundle " + bundleName, 1);
                    }
                    ZipOutputStream zipOutput = new ZipOutputStream(new FileOutputStream(this.output));
                    Object object = null;
                    Object var5_7 = null;
                    try {
                        try {
                            packer.pack(zipOutput);
                            if (this.manifest == null) break block23;
                            ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
                            zipOutput.putNextEntry(entry);
                            try {
                                PrintWriter writer = new PrintWriter(zipOutput);
                                this.manifest.write(writer);
                                writer.flush();
                            }
                            finally {
                                zipOutput.close();
                            }
                        }
                        finally {
                            if (zipOutput != null) {
                                zipOutput.close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new BuildException((Throwable)ex);
                }
            }
            finally {
                framework.close();
            }
        }
    }

    protected List<BundleItem> loadBundleItems(String baseDir) {
        ArrayList<BundleItem> bundles;
        block5: {
            bundles = new ArrayList<BundleItem>();
            System.out.println("load bundles from folder" + baseDir);
            File parent = new File(baseDir);
            File[] files = parent.listFiles();
            if (files == null) break block5;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    int pos;
                    String bundleName;
                    block6: {
                        File file = fileArray[n2];
                        bundleName = file.getName();
                        if (!file.isFile()) break block6;
                        if (!bundleName.endsWith(".jar")) break block7;
                        bundleName = bundleName.substring(0, bundleName.length() - 4);
                    }
                    if ((pos = bundleName.indexOf(95)) != -1) {
                        bundleName = bundleName.substring(0, pos);
                    }
                    BundleItem bundle = new BundleItem();
                    bundle.setName(bundleName);
                    bundles.add(bundle);
                }
                ++n2;
            }
        }
        return bundles;
    }

    protected File getFile(String baseDir, final String name) {
        File parent = new File(baseDir);
        File[] files = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.startsWith(String.valueOf(name) + "_");
            }
        });
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public Filter createFilter(BundleItem bundleItem) {
        String[] includes = this.getPatterns(bundleItem.getIncludeFilters());
        String[] excludes = this.getPatterns(bundleItem.getExcludeFilters());
        return new Filter(DEFAULT_FILTER, includes, excludes);
    }

    protected String[] getPatterns(List<FilterItem> filters) {
        if (filters == null) {
            return new String[0];
        }
        String[] patterns = new String[filters.size()];
        int i = 0;
        while (i < filters.size()) {
            patterns[i] = filters.get(i).getPattern();
            ++i;
        }
        return patterns;
    }
}

