/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class VerifyCompileUtils {
    private static String logLocation;
    private static String monitorLocatoin;
    private static StringBuffer buffer;
    private static int errorCount;

    static {
        buffer = new StringBuffer();
        errorCount = 0;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("[VerifyCompile] Missing arguments. VerifyCompile aborts!!");
            return;
        }
        logLocation = args[0];
        monitorLocatoin = args[1];
        if (!logLocation.endsWith("plugins")) {
            logLocation = String.valueOf(logLocation) + File.separator + "plugins";
        }
        if (!monitorLocatoin.endsWith("monitor.properties")) {
            monitorLocatoin = String.valueOf(monitorLocatoin) + File.separator + "monitor.properties";
        }
        System.out.println("[VerifyCompile] Log location: " + logLocation);
        System.out.println("[VerifyCompile] Monitor location: " + monitorLocatoin);
        File file = new File(logLocation);
        if (!file.exists()) {
            System.out.println("[VerifyCompile] " + logLocation + " does not exist");
            return;
        }
        File[] plugins = file.listFiles();
        System.out.println("[VerifyCompile] Total plugin: " + plugins.length);
        if (plugins.length > 0) {
            int i = 0;
            while (i < plugins.length) {
                if (plugins[i].isDirectory()) {
                    System.out.println("[VerifyCompile] Processing " + plugins[i].getName());
                    File[] htmlLogs = plugins[i].listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().toLowerCase().endsWith(".html");
                        }
                    });
                    File[] xmlLogs = plugins[i].listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().toLowerCase().endsWith(".xml");
                        }
                    });
                    if (xmlLogs.length == 0) {
                        System.out.println("[VerifyCompile] Emtpy log directory, continue for next...");
                    } else if (VerifyCompileUtils.checkCompileError(xmlLogs[0]) > 0) {
                        ++errorCount;
                        File errorPlugin = new File(xmlLogs[0].getParent());
                        File errorRepo = new File(String.valueOf(errorPlugin.getParent()) + File.separator + errorPlugin.getName() + "_compilelog.html");
                        System.out.println(errorRepo.getAbsolutePath());
                        if (htmlLogs.length > 0 && htmlLogs[0].exists()) {
                            htmlLogs[0].renameTo(errorRepo);
                        }
                        buffer.append(errorPlugin.getName());
                        buffer.append("\\n");
                        buffer.append("\\");
                        buffer.append("\n");
                    }
                }
                ++i;
            }
        }
        VerifyCompileUtils.appendProperties();
    }

    private static void appendProperties() {
        File monitor = new File(monitorLocatoin);
        BufferedWriter writer = null;
        System.out.println("[VerifyCompile] Error plugins count: " + errorCount);
        if (errorCount == 0) {
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(monitor, true));
                    writer.write("compileHasError=false");
                    writer.write("\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(monitor, true));
                    writer.write("compileHasError=true");
                    writer.write("\n");
                    writer.write("error.plugin.list=" + buffer.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        writer.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static int checkCompileError(File ResultFile) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(ResultFile);
        }
        catch (DocumentException dex) {
            dex.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        if (rootElement.getName().equals("compiler")) {
            Element stats = rootElement.element("stats");
            if (stats.element("problem_summary") != null) {
                Element problemSummary = stats.element("problem_summary");
                String sCount = problemSummary.attributeValue("errors");
                System.out.println("[VerifyCompile] Error Count: " + sCount);
                if (sCount.equals("0")) {
                    return 0;
                }
                return Integer.parseInt(sCount);
            }
            System.out.println("There is no element problem_summary!");
            return 0;
        }
        return 1;
    }
}

