/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.eclipse.birt.build.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginWrapper {
    File pluginFile = null;
    String pluginID = null;
    String pluginVersion = null;

    public PluginWrapper() {
    }

    public PluginWrapper(File pluginXML) {
        this.pluginFile = pluginXML;
        this.parse();
    }

    private void parse() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(this.pluginFile);
            NodeList nodes = doc.getElementsByTagName("plugin");
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                NamedNodeMap map = node.getAttributes();
                Node idNode = map.getNamedItem("id");
                Node versionNode = map.getNamedItem("version");
                if (idNode != null) {
                    this.pluginID = StringUtil.trimString(idNode.getNodeValue());
                }
                if (versionNode != null) {
                    this.pluginVersion = StringUtil.trimString(versionNode.getNodeValue());
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new BuildException("Exception occured when parsing :" + this.pluginFile + ". " + e);
        }
    }

    public void load(File pluginXML) {
        this.pluginFile = pluginXML;
        this.parse();
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }
}

