/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import java.io.FileWriter;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ParseResultCount {
    private static File ResultFile = null;
    private static String PluginName = null;
    private static String FailCase = null;
    private static String ErrorCase = null;
    private static String countError = null;
    private static String countFailure = null;

    public static void getResultFile(String testResultPath) {
        ResultFile = new File(testResultPath);
        if (ResultFile.exists()) {
            PluginName = ResultFile.getName();
        }
    }

    public static void main(String[] args) {
        int i = 0;
        ParseResultCount report = new ParseResultCount();
        File[] xmlReports = ParseResultCount.getTestResult(args[0]);
        String outputPath = args[1];
        countFailure = args[2];
        countError = args[3];
        int reportCount = xmlReports.length;
        i = 0;
        while (i < reportCount) {
            ResultFile = xmlReports[i];
            report.getTestResult();
            report.wrtTestReport(outputPath);
            ++i;
        }
    }

    private void getTestResult() {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(ResultFile);
        }
        catch (DocumentException dex) {
            dex.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        if (rootElement.getName().equals("testsuite")) {
            PluginName = rootElement.attributeValue("name");
            if (countFailure.equals("Y")) {
                FailCase = rootElement.attributeValue("failures");
            }
            if (countError.equals("Y")) {
                ErrorCase = rootElement.attributeValue("errors");
            }
        } else {
            Element testsuiteElement = rootElement.element("testsuite");
            PluginName = testsuiteElement.attributeValue("name");
            if (countFailure.equals("Y")) {
                FailCase = testsuiteElement.attributeValue("failures");
            }
            if (countError.equals("Y")) {
                ErrorCase = testsuiteElement.attributeValue("errors");
            }
        }
    }

    public static File[] getTestResult(String folder) {
        File file = new File(folder);
        File[] files = file.listFiles();
        if (files.length == 0) {
            return null;
        }
        return files;
    }

    private void wrtTestReport(String output) {
        try {
            File summaryPath = new File(output);
            FileWriter summaryOutput = new FileWriter(summaryPath, true);
            String line = null;
            if (countError.equals("Y")) {
                line = PluginName.concat("_error=");
                line = line.concat(ErrorCase);
                line = line.concat("\n");
                summaryOutput.write(line);
            }
            if (countFailure.equals("Y")) {
                line = PluginName.concat("_failure=");
                line = line.concat(FailCase);
                line = line.concat("\n");
                summaryOutput.write(line);
            }
            summaryOutput.flush();
            summaryOutput.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

