/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build;

import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.birt.build.SuffixFileFilter;

public class ParseCompileSummary {
    private static File ResultFile = null;
    private static String PluginName = null;
    private static String WarningCase = null;
    private static String ErrorCase = null;
    private static String countError = null;
    private static String countWarning = null;

    public static void getResultFile(String testResultPath) {
        ResultFile = new File(testResultPath);
        if (ResultFile.exists()) {
            PluginName = ResultFile.getName();
        }
    }

    public static void main(String[] args) {
        int i = 0;
        ParseCompileSummary report = new ParseCompileSummary();
        File[] xmlReports = ParseCompileSummary.getTestResult(args[0]);
        String outputPath = args[1];
        countWarning = args[2];
        countError = args[3];
        int reportCount = xmlReports.length;
        i = 0;
        while (i < reportCount) {
            File ResultFileFolder = xmlReports[i];
            if (!ResultFileFolder.isFile()) {
                File[] files = ResultFileFolder.listFiles(new SuffixFileFilter(".xml"));
                PluginName = ResultFileFolder.getName();
                System.out.println("Processing " + PluginName + "...");
                int j = 0;
                while (j < files.length) {
                    ResultFile = files[j];
                    report.getTestResult();
                    report.wrtTestReport(outputPath);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void getTestResult() {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(ResultFile);
        }
        catch (DocumentException dex) {
            dex.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        Element statElement = rootElement.element("stats");
        Iterator it = statElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String name = element.getName();
            if (!name.equalsIgnoreCase("problem_summary")) continue;
            if (countWarning.equals("Y")) {
                WarningCase = element.attributeValue("warnings");
            }
            if (countError.equals("Y")) {
                ErrorCase = element.attributeValue("errors");
            }
            return;
        }
        WarningCase = "0";
        ErrorCase = "0";
    }

    public static File[] getTestResult(String folder) {
        File file = new File(folder);
        File[] files = file.listFiles();
        if (files.length == 0) {
            return null;
        }
        return files;
    }

    private void wrtTestReport(String output) {
        try {
            File summaryPath = new File(output);
            FileWriter summaryOutput = new FileWriter(summaryPath, true);
            String line = null;
            if (countError.equals("Y")) {
                line = PluginName.concat("_error=");
                line = line.concat(ErrorCase);
                line = line.concat("\n");
                summaryOutput.write(line);
            }
            if (countWarning.equals("Y")) {
                line = PluginName.concat("_warning=");
                line = line.concat(WarningCase);
                line = line.concat("\n");
                summaryOutput.write(line);
            }
            summaryOutput.flush();
            summaryOutput.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

