/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.gimap.protocol;

import jakarta.mail.search.SearchException;
import jakarta.mail.search.SearchTerm;
import java.io.IOException;
import org.eclipse.angus.mail.gimap.GmailMsgIdTerm;
import org.eclipse.angus.mail.gimap.GmailRawSearchTerm;
import org.eclipse.angus.mail.gimap.GmailThrIdTerm;
import org.eclipse.angus.mail.iap.Argument;
import org.eclipse.angus.mail.imap.protocol.IMAPProtocol;
import org.eclipse.angus.mail.imap.protocol.SearchSequence;

public class GmailSearchSequence
extends SearchSequence {
    public GmailSearchSequence(IMAPProtocol p) {
        super(p);
    }

    public Argument generateSequence(SearchTerm term, String charset) throws SearchException, IOException {
        if (term instanceof GmailMsgIdTerm) {
            return this.gmailMsgidSearch((GmailMsgIdTerm)term);
        }
        if (term instanceof GmailThrIdTerm) {
            return this.gmailThridSearch((GmailThrIdTerm)term);
        }
        if (term instanceof GmailRawSearchTerm) {
            return this.gmailRawSearch((GmailRawSearchTerm)term, charset);
        }
        return super.generateSequence(term, charset);
    }

    protected Argument gmailMsgidSearch(GmailMsgIdTerm term) throws IOException {
        Argument result = new Argument();
        result.writeAtom("X-GM-MSGID");
        result.writeNumber(term.getNumber());
        return result;
    }

    protected Argument gmailThridSearch(GmailThrIdTerm term) throws IOException {
        Argument result = new Argument();
        result.writeAtom("X-GM-THRID");
        result.writeNumber(term.getNumber());
        return result;
    }

    protected Argument gmailRawSearch(GmailRawSearchTerm term, String charset) throws IOException {
        Argument result = new Argument();
        result.writeAtom("X-GM-RAW");
        result.writeString(term.getPattern(), charset);
        return result;
    }
}

