/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util;

import java.io.PrintStream;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;

public final class TestLoggerFactory
implements LoggerFactory {
    private final Logger logger;

    public TestLoggerFactory() {
        this(null);
    }

    public TestLoggerFactory(PrintStream out) {
        this.logger = new TestLogger(out);
    }

    public Logger getLogger(String name) {
        return this.logger;
    }

    private static final class TestLogger
    implements Logger {
        private final PrintStream out;

        public TestLogger(PrintStream out) {
            this.out = out != null ? out : System.out;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public void warn(String msg, Throwable error) {
            this.out.println("[WARN] " + msg);
            if (error != null) {
                error.printStackTrace(this.out);
            }
        }

        public void warn(String msg) {
            this.warn(msg, null);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void debug(String msg, Throwable error) {
            this.out.println("[DEBUG] " + msg);
            if (error != null) {
                error.printStackTrace(this.out);
            }
        }

        public void debug(String msg) {
            this.debug(msg, null);
        }
    }
}

