/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.util.connector.suite;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.test.impl.RecordingTransferListener;
import org.eclipse.aether.internal.test.impl.TestRepositorySystemSession;
import org.eclipse.aether.internal.test.util.TestFileUtils;
import org.eclipse.aether.internal.test.util.connector.suite.ConnectorTestUtils;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferEventTester {
    public static void testSuccessfulTransferEvents(RepositoryConnectorFactory factory, TestRepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException, IOException {
        RecordingTransferListener listener = new RecordingTransferListener(session.getTransferListener());
        session.setTransferListener(listener);
        RepositoryConnector connector = factory.newInstance((RepositorySystemSession)session, repository);
        byte[] pattern = "tmpFile".getBytes();
        File tmpFile = TestFileUtils.createTempFile(pattern, 10000);
        long expectedBytes = tmpFile.length();
        List<ArtifactUpload> artUps = ConnectorTestUtils.createTransfers(ArtifactUpload.class, 1, tmpFile);
        List<ArtifactDownload> artDowns = ConnectorTestUtils.createTransfers(ArtifactDownload.class, 1, tmpFile);
        List<MetadataUpload> metaUps = ConnectorTestUtils.createTransfers(MetadataUpload.class, 1, tmpFile);
        List<MetadataDownload> metaDowns = ConnectorTestUtils.createTransfers(MetadataDownload.class, 1, tmpFile);
        connector.put(artUps, null);
        LinkedList<TransferEvent> events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkEvents(events, expectedBytes);
        listener.clear();
        connector.get(artDowns, null);
        events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkEvents(events, expectedBytes);
        listener.clear();
        connector.put(null, metaUps);
        events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkEvents(events, expectedBytes);
        listener.clear();
        connector.get(null, metaDowns);
        events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkEvents(events, expectedBytes);
        connector.close();
        session.setTransferListener(null);
    }

    private static void checkEvents(Queue<TransferEvent> events, long expectedBytes) {
        TransferEvent currentEvent = events.poll();
        String msg = "initiate event is missing";
        Assert.assertNotNull((String)msg, (Object)currentEvent);
        Assert.assertEquals((String)msg, (Object)TransferEvent.EventType.INITIATED, (Object)currentEvent.getType());
        TransferEventTester.checkProperties(currentEvent);
        TransferResource expectedResource = currentEvent.getResource();
        currentEvent = events.poll();
        msg = "start event is missing";
        Assert.assertNotNull((String)msg, (Object)currentEvent);
        Assert.assertEquals((String)msg, (Object)TransferEvent.EventType.STARTED, (Object)currentEvent.getType());
        Assert.assertEquals((String)"bad content length", (long)expectedBytes, (long)currentEvent.getResource().getContentLength());
        TransferEventTester.checkProperties(currentEvent);
        TransferEventTester.assertResourceEquals(expectedResource, currentEvent.getResource());
        TransferEvent.EventType progressed = TransferEvent.EventType.PROGRESSED;
        TransferEvent.EventType succeeded = TransferEvent.EventType.SUCCEEDED;
        TransferEvent succeedEvent = null;
        int dataLength = 0;
        long transferredBytes = 0L;
        while ((currentEvent = events.poll()) != null) {
            TransferEvent.EventType currentType = currentEvent.getType();
            TransferEventTester.assertResourceEquals(expectedResource, currentEvent.getResource());
            if (succeeded.equals((Object)currentType)) {
                succeedEvent = currentEvent;
                TransferEventTester.checkProperties(currentEvent);
                break;
            }
            Assert.assertTrue((String)"event is not 'succeeded' and not 'progressed'", (boolean)progressed.equals((Object)currentType));
            Assert.assertTrue((String)("wrong order of progressed events, transferredSize got smaller, last = " + transferredBytes + ", current = " + currentEvent.getTransferredBytes()), (currentEvent.getTransferredBytes() >= transferredBytes ? 1 : 0) != 0);
            Assert.assertEquals((String)"bad content length", (long)expectedBytes, (long)currentEvent.getResource().getContentLength());
            transferredBytes = currentEvent.getTransferredBytes();
            dataLength += currentEvent.getDataBuffer().remaining();
            TransferEventTester.checkProperties(currentEvent);
        }
        Assert.assertEquals((String)("too many events left: " + events.toString()), (long)0L, (long)events.size());
        Assert.assertEquals((String)"progress events transferred bytes don't match: data length does not add up", (long)expectedBytes, (long)dataLength);
        Assert.assertEquals((String)"succeed event transferred bytes don't match", (long)expectedBytes, (long)succeedEvent.getTransferredBytes());
    }

    private static void assertResourceEquals(TransferResource expected, TransferResource actual) {
        Assert.assertEquals((String)"TransferResource: content length does not match.", (long)expected.getContentLength(), (long)actual.getContentLength());
        Assert.assertEquals((String)"TransferResource: file does not match.", (Object)expected.getFile(), (Object)actual.getFile());
        Assert.assertEquals((String)"TransferResource: repo url does not match.", (Object)expected.getRepositoryUrl(), (Object)actual.getRepositoryUrl());
        Assert.assertEquals((String)"TransferResource: transfer start time does not match.", (long)expected.getTransferStartTime(), (long)actual.getTransferStartTime());
        Assert.assertEquals((String)"TransferResource: name does not match.", (Object)expected.getResourceName(), (Object)actual.getResourceName());
    }

    private static void checkProperties(TransferEvent event) {
        Assert.assertNotNull((String)("resource is null for type: " + event.getType()), (Object)event.getResource());
        Assert.assertNotNull((String)("request type is null for type: " + event.getType()), (Object)event.getRequestType());
        Assert.assertNotNull((String)("type is null for type: " + event.getType()), (Object)event.getType());
        if (TransferEvent.EventType.PROGRESSED.equals((Object)event.getType())) {
            Assert.assertNotNull((String)("data buffer is null for type: " + event.getType()), (Object)event.getDataBuffer());
            Assert.assertTrue((String)("transferred byte is not set/not positive for type: " + event.getType()), (event.getTransferredBytes() > -1L ? 1 : 0) != 0);
        } else if (TransferEvent.EventType.SUCCEEDED.equals((Object)event.getType())) {
            Assert.assertTrue((String)("transferred byte is not set/not positive for type: " + event.getType()), (event.getTransferredBytes() > -1L ? 1 : 0) != 0);
        }
    }

    public static void testFailedTransferEvents(RepositoryConnectorFactory factory, TestRepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException, IOException {
        RecordingTransferListener listener = new RecordingTransferListener(session.getTransferListener());
        session.setTransferListener(listener);
        RepositoryConnector connector = factory.newInstance((RepositorySystemSession)session, repository);
        byte[] pattern = "tmpFile".getBytes("us-ascii");
        File tmpFile = TestFileUtils.createTempFile(pattern, 10000);
        List<ArtifactUpload> artUps = ConnectorTestUtils.createTransfers(ArtifactUpload.class, 1, null);
        List<ArtifactDownload> artDowns = ConnectorTestUtils.createTransfers(ArtifactDownload.class, 1, tmpFile);
        List<MetadataUpload> metaUps = ConnectorTestUtils.createTransfers(MetadataUpload.class, 1, null);
        List<MetadataDownload> metaDowns = ConnectorTestUtils.createTransfers(MetadataDownload.class, 1, tmpFile);
        connector.put(artUps, null);
        LinkedList<TransferEvent> events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkFailedEvents(events, null);
        listener.clear();
        connector.get(artDowns, null);
        events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkFailedEvents(events, null);
        listener.clear();
        connector.put(null, metaUps);
        events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkFailedEvents(events, null);
        listener.clear();
        connector.get(null, metaDowns);
        events = new LinkedList<TransferEvent>(listener.getEvents());
        TransferEventTester.checkFailedEvents(events, null);
        connector.close();
        session.setTransferListener(null);
    }

    private static void checkFailedEvents(Queue<TransferEvent> events, Class<? extends Throwable> expectedError) {
        if (expectedError == null) {
            expectedError = Throwable.class;
        }
        TransferEvent currentEvent = events.poll();
        String msg = "initiate event is missing";
        Assert.assertNotNull((String)msg, (Object)currentEvent);
        Assert.assertEquals((String)msg, (Object)TransferEvent.EventType.INITIATED, (Object)currentEvent.getType());
        TransferEventTester.checkProperties(currentEvent);
        currentEvent = events.poll();
        msg = "fail event is missing";
        Assert.assertNotNull((String)msg, (Object)currentEvent);
        Assert.assertEquals((String)msg, (Object)TransferEvent.EventType.FAILED, (Object)currentEvent.getType());
        TransferEventTester.checkProperties(currentEvent);
        Assert.assertNotNull((String)"exception is missing for fail event", (Object)currentEvent.getException());
        Exception exception = currentEvent.getException();
        Assert.assertTrue((String)("exception is of wrong type, should be instance of " + expectedError + " but was " + exception.getClass()), (boolean)expectedError.isAssignableFrom(exception.getClass()));
        Assert.assertEquals((String)("too many events left: " + events.toString()), (long)0L, (long)events.size());
    }
}

