/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.test.impl;

import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;

public final class SysoutLoggerFactory
implements LoggerFactory {
    public static final Logger LOGGER = new SysoutLogger();

    public Logger getLogger(String name) {
        return LOGGER;
    }

    private static final class SysoutLogger
    implements Logger {
        private SysoutLogger() {
        }

        public void warn(String msg, Throwable error) {
            this.warn(msg);
            if (error != null) {
                error.printStackTrace(System.err);
            }
        }

        public void warn(String msg) {
            System.err.println(msg);
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void debug(String msg, Throwable error) {
            this.debug(msg);
            if (error != null) {
                error.printStackTrace(System.err);
            }
        }

        public void debug(String msg) {
            System.out.println(msg);
        }
    }
}

