/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultFileProcessor;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultSyncContextFactory;
import org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import org.eclipse.aether.internal.impl.Slf4jLoggerFactory;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServiceLocator
implements ServiceLocator {
    private final Map<Class<?>, Collection<Class<?>>> classes = new HashMap();
    private final Map<Class<?>, List<?>> instances = new HashMap();
    private ErrorHandler errorHandler;

    public DefaultServiceLocator() {
        this.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        this.addService(ArtifactResolver.class, DefaultArtifactResolver.class);
        this.addService(DependencyCollector.class, DefaultDependencyCollector.class);
        this.addService(Deployer.class, DefaultDeployer.class);
        this.addService(Installer.class, DefaultInstaller.class);
        this.addService(MetadataResolver.class, DefaultMetadataResolver.class);
        this.addService(RepositoryConnectorProvider.class, DefaultRepositoryConnectorProvider.class);
        this.addService(RemoteRepositoryManager.class, DefaultRemoteRepositoryManager.class);
        this.addService(UpdateCheckManager.class, DefaultUpdateCheckManager.class);
        this.addService(UpdatePolicyAnalyzer.class, DefaultUpdatePolicyAnalyzer.class);
        this.addService(FileProcessor.class, DefaultFileProcessor.class);
        this.addService(SyncContextFactory.class, DefaultSyncContextFactory.class);
        this.addService(RepositoryEventDispatcher.class, DefaultRepositoryEventDispatcher.class);
        this.addService(LocalRepositoryProvider.class, DefaultLocalRepositoryProvider.class);
        this.addService(LocalRepositoryManagerFactory.class, SimpleLocalRepositoryManagerFactory.class);
        this.addService(LocalRepositoryManagerFactory.class, EnhancedLocalRepositoryManagerFactory.class);
        if (Slf4jLoggerFactory.isSlf4jAvailable()) {
            this.addService(LoggerFactory.class, Slf4jLoggerFactory.class);
        }
    }

    public <T> DefaultServiceLocator setService(Class<T> type, Class<? extends T> impl) {
        this.classes.remove(type);
        return this.addService(type, impl);
    }

    public <T> DefaultServiceLocator addService(Class<T> type, Class<? extends T> impl) {
        if (impl == null) {
            throw new IllegalArgumentException("implementation class must not be null");
        }
        Collection<Class<?>> impls = this.classes.get(type);
        if (impls == null) {
            impls = new LinkedHashSet();
            this.classes.put(type, impls);
        }
        impls.add(impl);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DefaultServiceLocator setServices(Class<T> type, T ... services) {
        Map<Class<?>, List<?>> map = this.instances;
        synchronized (map) {
            this.instances.put(type, Arrays.asList(services));
        }
        return this;
    }

    public <T> T getService(Class<T> type) {
        List<T> objs = this.getServices(type);
        return objs.isEmpty() ? null : (T)objs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getServices(Class<T> type) {
        Map<Class<?>, List<?>> map = this.instances;
        synchronized (map) {
            List<Object> objs = this.instances.get(type);
            if (objs == null) {
                Iterator<Object> it;
                Collection<Class<?>> impls = this.classes.get(type);
                if (impls == null || impls.isEmpty()) {
                    objs = Collections.emptyList();
                    it = objs.iterator();
                } else {
                    objs = new ArrayList(impls.size());
                    for (Class<?> impl : impls) {
                        try {
                            Constructor<?> constr = impl.getDeclaredConstructor(new Class[0]);
                            if (!Modifier.isPublic(constr.getModifiers())) {
                                constr.setAccessible(true);
                            }
                            Object obj = constr.newInstance(new Object[0]);
                            objs.add(type.cast(obj));
                        }
                        catch (Exception e) {
                            this.serviceCreationFailed(type, impl, e);
                        }
                        catch (LinkageError e) {
                            this.serviceCreationFailed(type, impl, e);
                        }
                    }
                    it = objs.iterator();
                    objs = Collections.unmodifiableList(objs);
                }
                this.instances.put(type, objs);
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof Service)) continue;
                    try {
                        ((Service)obj).initService((ServiceLocator)this);
                    }
                    catch (Exception e) {
                        it.remove();
                        this.serviceCreationFailed(type, obj.getClass(), e);
                    }
                    catch (LinkageError e) {
                        it.remove();
                        this.serviceCreationFailed(type, obj.getClass(), e);
                    }
                }
            }
            return objs;
        }
    }

    private void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
        if (this.errorHandler != null) {
            this.errorHandler.serviceCreationFailed(type, impl, exception);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ErrorHandler {
        public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
        }
    }
}

