/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.util.ChecksumUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChecksumCalculator {
    private final Map<String, MessageDigest> digests = new HashMap<String, MessageDigest>();
    private final File targetFile;
    private Exception targetFileError;

    public static ChecksumCalculator newInstance(File targetFile, Collection<RepositoryLayout.Checksum> checksums) {
        if (checksums == null || checksums.isEmpty()) {
            return null;
        }
        return new ChecksumCalculator(targetFile, checksums);
    }

    private ChecksumCalculator(File targetFile, Collection<RepositoryLayout.Checksum> checksums) {
        for (RepositoryLayout.Checksum checksum : checksums) {
            String algo = checksum.getAlgorithm();
            try {
                if (this.digests.containsKey(algo)) continue;
                MessageDigest digest = MessageDigest.getInstance(algo);
                this.digests.put(algo, digest);
            }
            catch (NoSuchAlgorithmException e) {}
        }
        this.targetFile = targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long dataOffset) {
        for (MessageDigest digest : this.digests.values()) {
            digest.reset();
        }
        this.targetFileError = null;
        if (dataOffset <= 0L) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(this.targetFile);
            try {
                long total = 0L;
                byte[] buffer = new byte[32768];
                while (total < dataOffset) {
                    int read = fis.read(buffer);
                    if (read < 0) {
                        if (total < dataOffset) {
                            throw new IOException(this.targetFile + " contains only " + total + " bytes, cannot resume download from offset " + dataOffset);
                        }
                        break;
                    }
                    if ((total += (long)read) > dataOffset) {
                        read = (int)((long)read - (total - dataOffset));
                    }
                    for (MessageDigest digest : this.digests.values()) {
                        digest.update(buffer, 0, read);
                    }
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            this.targetFileError = e;
        }
    }

    public void update(ByteBuffer data) {
        for (MessageDigest digest : this.digests.values()) {
            data.mark();
            digest.update(data);
            data.reset();
        }
    }

    public Map<String, Object> get() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (this.targetFileError != null) {
            for (String algo : this.digests.keySet()) {
                results.put(algo, this.targetFileError);
            }
        } else {
            for (Map.Entry<String, MessageDigest> entry : this.digests.entrySet()) {
                results.put(entry.getKey(), ChecksumUtils.toHexString((byte[])entry.getValue().digest()));
            }
        }
        return results;
    }
}

