/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;

@Named(value="basic")
@Component(role=RepositoryConnectorFactory.class, hint="basic")
public final class BasicRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private TransporterProvider transporterProvider;
    @Requirement
    private RepositoryLayoutProvider layoutProvider;
    @Requirement
    private FileProcessor fileProcessor;
    private float priority;

    public BasicRepositoryConnectorFactory() {
    }

    @Inject
    BasicRepositoryConnectorFactory(TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, FileProcessor fileProcessor, LoggerFactory loggerFactory) {
        this.setTransporterProvider(transporterProvider);
        this.setRepositoryLayoutProvider(layoutProvider);
        this.setFileProcessor(fileProcessor);
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setTransporterProvider((TransporterProvider)locator.getService(TransporterProvider.class));
        this.setRepositoryLayoutProvider((RepositoryLayoutProvider)locator.getService(RepositoryLayoutProvider.class));
        this.setFileProcessor((FileProcessor)locator.getService(FileProcessor.class));
    }

    public BasicRepositoryConnectorFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, BasicRepositoryConnector.class);
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public BasicRepositoryConnectorFactory setTransporterProvider(TransporterProvider transporterProvider) {
        if (transporterProvider == null) {
            throw new IllegalArgumentException("transporter provider has not been specified");
        }
        this.transporterProvider = transporterProvider;
        return this;
    }

    public BasicRepositoryConnectorFactory setRepositoryLayoutProvider(RepositoryLayoutProvider layoutProvider) {
        if (layoutProvider == null) {
            throw new IllegalArgumentException("repository layout provider has not been specified");
        }
        this.layoutProvider = layoutProvider;
        return this;
    }

    public BasicRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public BasicRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        return new BasicRepositoryConnector(session, repository, this.transporterProvider, this.layoutProvider, this.fileProcessor, this.logger);
    }
}

