/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyResult {
    private final DependencyRequest request;
    private DependencyNode root;
    private List<Exception> collectExceptions;
    private List<ArtifactResult> artifactResults;

    public DependencyResult(DependencyRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("dependency request has not been specified");
        }
        this.request = request;
        this.root = request.getRoot();
        this.collectExceptions = new ArrayList<Exception>(2);
        this.artifactResults = new ArrayList<ArtifactResult>(2);
    }

    public DependencyRequest getRequest() {
        return this.request;
    }

    public DependencyNode getRoot() {
        return this.root;
    }

    public DependencyResult setRoot(DependencyNode root) {
        this.root = root;
        return this;
    }

    public List<Exception> getCollectExceptions() {
        return this.collectExceptions;
    }

    public DependencyResult setCollectExceptions(List<Exception> exceptions) {
        this.collectExceptions = exceptions != null ? exceptions : new ArrayList();
        return this;
    }

    public List<ArtifactResult> getArtifactResults() {
        return this.artifactResults;
    }

    public DependencyResult setArtifactResults(List<ArtifactResult> results) {
        this.artifactResults = results != null ? results : new ArrayList();
        return this;
    }

    public String toString() {
        return String.valueOf(this.artifactResults);
    }
}

