/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.internal.ant.AntRepoSys;
import org.eclipse.aether.internal.ant.types.Authentication;

public class Mirror
extends DataType {
    private String id;
    private String url;
    private String type;
    private String mirrorOf;
    private Authentication authentication;

    public void setProject(Project project) {
        super.setProject(project);
        AntRepoSys.getInstance(project).addMirror(this);
    }

    protected Mirror getRef() {
        return (Mirror)((Object)this.getCheckedRef());
    }

    public void setRefid(Reference ref) {
        if (this.id != null || this.url != null || this.mirrorOf != null || this.type != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(ref);
    }

    public String getId() {
        if (this.isReference()) {
            return this.getRef().getId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        if (this.isReference()) {
            return this.getRef().getUrl();
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.checkAttributesAllowed();
        this.url = url;
    }

    public String getType() {
        if (this.isReference()) {
            return this.getRef().getType();
        }
        return this.type != null ? this.type : "default";
    }

    public void setType(String type) {
        this.checkAttributesAllowed();
        this.type = type;
    }

    public String getMirrorOf() {
        if (this.isReference()) {
            return this.getRef().getMirrorOf();
        }
        return this.mirrorOf;
    }

    public void setMirrorOf(String mirrorOf) {
        this.checkAttributesAllowed();
        this.mirrorOf = mirrorOf;
    }

    public void addAuthentication(Authentication authentication) {
        this.checkChildrenAllowed();
        if (this.authentication != null) {
            throw new BuildException("You must not specify multiple <authentication> elements");
        }
        this.authentication = authentication;
    }

    public Authentication getAuthentication() {
        if (this.isReference()) {
            this.getRef().getAuthentication();
        }
        return this.authentication;
    }

    public void setAuthRef(Reference ref) {
        if (this.authentication == null) {
            this.authentication = new Authentication();
            this.authentication.setProject(this.getProject());
        }
        this.authentication.setRefid(ref);
    }
}

