/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.ant.util;

import java.io.File;
import org.apache.tools.ant.Project;
import org.eclipse.aether.ant.types.RemoteRepositories;

public class AetherUtils {
    public static File findGlobalSettings(Project project) {
        File file = new File(new File(project.getProperty("ant.home"), "etc"), "settings.xml");
        if (file.isFile()) {
            return file;
        }
        String mavenHome = AetherUtils.getMavenHome(project);
        if (mavenHome != null) {
            return new File(new File(mavenHome, "conf"), "settings.xml");
        }
        return null;
    }

    public static String getMavenHome(Project project) {
        String mavenHome = project.getProperty("maven.home");
        if (mavenHome != null) {
            return mavenHome;
        }
        return System.getenv("M2_HOME");
    }

    public static File findUserSettings(Project project) {
        File userHome = new File(project.getProperty("user.home"));
        File file = new File(new File(userHome, ".ant"), "settings.xml");
        if (file.isFile()) {
            return file;
        }
        return new File(new File(userHome, ".m2"), "settings.xml");
    }

    public static RemoteRepositories getDefaultRepositories(Project project) {
        Object obj = project.getReference("aether.repositories");
        if (obj instanceof RemoteRepositories) {
            return (RemoteRepositories)obj;
        }
        return null;
    }
}

