/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.ant.types;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;
import org.eclipse.aether.ant.types.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dependency
extends DataType {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;
    private String scope;
    private File systemPath;
    private List<Exclusion> exclusions = new ArrayList<Exclusion>();

    protected Dependency getRef() {
        return (Dependency)((Object)this.getCheckedRef());
    }

    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            if (this.groupId == null || this.groupId.length() <= 0) {
                throw new BuildException("You must specify the 'groupId' for a dependency");
            }
            if (this.artifactId == null || this.artifactId.length() <= 0) {
                throw new BuildException("You must specify the 'artifactId' for a dependency");
            }
            if (this.version == null || this.version.length() <= 0) {
                throw new BuildException("You must specify the 'version' for a dependency");
            }
            if ("system".equals(this.scope)) {
                if (this.systemPath == null) {
                    throw new BuildException("You must specify 'systemPath' for dependencies with scope=system");
                }
            } else if (this.systemPath != null) {
                throw new BuildException("You may only specify 'systemPath' for dependencies with scope=system");
            }
            if (!(this.scope == null || "compile".equals(this.scope) || "provided".equals(this.scope) || "system".equals(this.scope) || "runtime".equals(this.scope) || "test".equals(this.scope))) {
                task.log("Unknown scope '" + this.scope + "' for dependency", 1);
            }
            for (Exclusion exclusion : this.exclusions) {
                exclusion.validate(task);
            }
        }
    }

    public void setRefid(Reference ref) {
        if (this.groupId != null || this.artifactId != null || this.type != null || this.classifier != null || this.version != null || this.scope != null || this.systemPath != null) {
            throw this.tooManyAttributes();
        }
        if (!this.exclusions.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public String getGroupId() {
        if (this.isReference()) {
            return this.getRef().getGroupId();
        }
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.checkAttributesAllowed();
        if (this.groupId != null) {
            throw this.ambiguousCoords();
        }
        this.groupId = groupId;
    }

    public String getArtifactId() {
        if (this.isReference()) {
            return this.getRef().getArtifactId();
        }
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.checkAttributesAllowed();
        if (this.artifactId != null) {
            throw this.ambiguousCoords();
        }
        this.artifactId = artifactId;
    }

    public String getVersion() {
        if (this.isReference()) {
            return this.getRef().getVersion();
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.checkAttributesAllowed();
        if (this.version != null) {
            throw this.ambiguousCoords();
        }
        this.version = version;
    }

    public String getClassifier() {
        if (this.isReference()) {
            return this.getRef().getClassifier();
        }
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.checkAttributesAllowed();
        if (this.classifier != null) {
            throw this.ambiguousCoords();
        }
        this.classifier = classifier;
    }

    public String getType() {
        if (this.isReference()) {
            return this.getRef().getType();
        }
        return this.type != null ? this.type : "jar";
    }

    public void setType(String type) {
        this.checkAttributesAllowed();
        if (this.type != null) {
            throw this.ambiguousCoords();
        }
        this.type = type;
    }

    public String getScope() {
        if (this.isReference()) {
            return this.getRef().getScope();
        }
        return this.scope != null ? this.scope : "compile";
    }

    public void setScope(String scope) {
        this.checkAttributesAllowed();
        if (this.scope != null) {
            throw this.ambiguousCoords();
        }
        this.scope = scope;
    }

    public void setCoords(String coords) {
        this.checkAttributesAllowed();
        if (this.groupId != null || this.artifactId != null || this.version != null || this.type != null || this.classifier != null || this.scope != null) {
            throw this.ambiguousCoords();
        }
        Pattern p = Pattern.compile("([^: ]+):([^: ]+):([^: ]+)((:([^: ]+)(:([^: ]+))?)?:([^: ]+))?");
        Matcher m = p.matcher(coords);
        if (!m.matches()) {
            throw new BuildException("Bad dependency coordinates, expected format is <groupId>:<artifactId>:<version>[[:<type>[:<classifier>]]:<scope>]");
        }
        this.groupId = m.group(1);
        this.artifactId = m.group(2);
        this.version = m.group(3);
        this.type = m.group(6);
        if (this.type == null || this.type.length() <= 0) {
            this.type = "jar";
        }
        this.classifier = m.group(8);
        if (this.classifier == null) {
            this.classifier = "";
        }
        this.scope = m.group(9);
    }

    public void setSystemPath(File systemPath) {
        this.checkAttributesAllowed();
        this.systemPath = systemPath;
    }

    public File getSystemPath() {
        if (this.isReference()) {
            return this.getRef().getSystemPath();
        }
        return this.systemPath;
    }

    public String getVersionlessKey() {
        if (this.isReference()) {
            return this.getRef().getVersionlessKey();
        }
        StringBuilder key = new StringBuilder(128);
        if (this.groupId != null) {
            key.append(this.groupId);
        }
        key.append(':');
        if (this.artifactId != null) {
            key.append(this.artifactId);
        }
        key.append(':');
        key.append(this.type != null ? this.type : "jar");
        if (this.classifier != null && this.classifier.length() > 0) {
            key.append(':');
            key.append(this.classifier);
        }
        return key.toString();
    }

    public void addExclusion(Exclusion exclusion) {
        this.checkChildrenAllowed();
        this.exclusions.add(exclusion);
    }

    public List<Exclusion> getExclusions() {
        if (this.isReference()) {
            return this.getRef().getExclusions();
        }
        return this.exclusions;
    }

    private BuildException ambiguousCoords() {
        return new BuildException("You must not specify both 'coords' and ('groupId', 'artifactId', 'version', 'extension', 'classifier', 'scope')");
    }
}

