/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.recovery;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.AddressResolver;
import com.rabbitmq.client.BlockedCallback;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.ListAddressResolver;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.MissedHeartbeatException;
import com.rabbitmq.client.NoOpMetricsCollector;
import com.rabbitmq.client.RecoverableConnection;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.TopologyRecoveryException;
import com.rabbitmq.client.UnblockedCallback;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ConnectionParams;
import com.rabbitmq.client.impl.FrameHandlerFactory;
import com.rabbitmq.client.impl.NetworkConnection;
import com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import com.rabbitmq.client.impl.recovery.ConsumerRecoveryListener;
import com.rabbitmq.client.impl.recovery.QueueRecoveryListener;
import com.rabbitmq.client.impl.recovery.RecordedBinding;
import com.rabbitmq.client.impl.recovery.RecordedConsumer;
import com.rabbitmq.client.impl.recovery.RecordedEntity;
import com.rabbitmq.client.impl.recovery.RecordedExchange;
import com.rabbitmq.client.impl.recovery.RecordedExchangeBinding;
import com.rabbitmq.client.impl.recovery.RecordedQueue;
import com.rabbitmq.client.impl.recovery.RecordedQueueBinding;
import com.rabbitmq.client.impl.recovery.RecoveryAwareAMQConnection;
import com.rabbitmq.client.impl.recovery.RecoveryAwareAMQConnectionFactory;
import com.rabbitmq.client.impl.recovery.RecoveryAwareChannelN;
import com.rabbitmq.client.impl.recovery.RecoveryCanBeginListener;
import com.rabbitmq.client.impl.recovery.RetryContext;
import com.rabbitmq.client.impl.recovery.RetryHandler;
import com.rabbitmq.client.impl.recovery.RetryResult;
import com.rabbitmq.client.impl.recovery.TopologyRecoveryFilter;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutorecoveringConnection
implements RecoverableConnection,
NetworkConnection {
    public static final Predicate<ShutdownSignalException> DEFAULT_CONNECTION_RECOVERY_TRIGGERING_CONDITION = cause -> !cause.isInitiatedByApplication() || cause.getCause() instanceof MissedHeartbeatException;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutorecoveringConnection.class);
    private final RecoveryAwareAMQConnectionFactory cf;
    private final Map<Integer, AutorecoveringChannel> channels;
    private final ConnectionParams params;
    private volatile RecoveryAwareAMQConnection delegate;
    private final List<ShutdownListener> shutdownHooks = Collections.synchronizedList(new ArrayList());
    private final List<RecoveryListener> recoveryListeners = Collections.synchronizedList(new ArrayList());
    private final List<BlockedListener> blockedListeners = Collections.synchronizedList(new ArrayList());
    private final Map<String, RecordedQueue> recordedQueues = Collections.synchronizedMap(new LinkedHashMap());
    private final List<RecordedBinding> recordedBindings = Collections.synchronizedList(new ArrayList());
    private final Map<String, RecordedExchange> recordedExchanges = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, RecordedConsumer> consumers = Collections.synchronizedMap(new LinkedHashMap());
    private final List<ConsumerRecoveryListener> consumerRecoveryListeners = Collections.synchronizedList(new ArrayList());
    private final List<QueueRecoveryListener> queueRecoveryListeners = Collections.synchronizedList(new ArrayList());
    private final TopologyRecoveryFilter topologyRecoveryFilter;
    private volatile boolean manuallyClosed = false;
    private final Object recoveryLock = new Object();
    private final Predicate<ShutdownSignalException> connectionRecoveryTriggeringCondition;
    private final RetryHandler retryHandler;

    public AutorecoveringConnection(ConnectionParams params, FrameHandlerFactory f, List<Address> addrs) {
        this(params, f, new ListAddressResolver(addrs));
    }

    public AutorecoveringConnection(ConnectionParams params, FrameHandlerFactory f, AddressResolver addressResolver) {
        this(params, f, addressResolver, new NoOpMetricsCollector());
    }

    public AutorecoveringConnection(ConnectionParams params, FrameHandlerFactory f, AddressResolver addressResolver, MetricsCollector metricsCollector) {
        this.cf = new RecoveryAwareAMQConnectionFactory(params, f, addressResolver, metricsCollector);
        this.params = params;
        this.connectionRecoveryTriggeringCondition = params.getConnectionRecoveryTriggeringCondition() == null ? DEFAULT_CONNECTION_RECOVERY_TRIGGERING_CONDITION : params.getConnectionRecoveryTriggeringCondition();
        this.setupErrorOnWriteListenerForPotentialRecovery();
        this.channels = new ConcurrentHashMap<Integer, AutorecoveringChannel>();
        this.topologyRecoveryFilter = params.getTopologyRecoveryFilter() == null ? this.letAllPassFilter() : params.getTopologyRecoveryFilter();
        this.retryHandler = params.getTopologyRecoveryRetryHandler();
    }

    private void setupErrorOnWriteListenerForPotentialRecovery() {
        ThreadFactory threadFactory = this.params.getThreadFactory();
        ReentrantLock errorOnWriteLock = new ReentrantLock();
        this.params.setErrorOnWriteListener((connection, exception) -> {
            if (errorOnWriteLock.tryLock()) {
                try {
                    Thread recoveryThread = threadFactory.newThread(() -> {
                        AMQConnection c = (AMQConnection)connection;
                        c.handleIoError(exception);
                    });
                    recoveryThread.setName("RabbitMQ Error On Write Thread");
                    recoveryThread.start();
                }
                finally {
                    errorOnWriteLock.unlock();
                }
            }
            throw exception;
        });
    }

    private TopologyRecoveryFilter letAllPassFilter() {
        return new TopologyRecoveryFilter(){};
    }

    public void init() throws IOException, TimeoutException {
        this.delegate = this.cf.newConnection();
        this.addAutomaticRecoveryListener(this.delegate);
    }

    @Override
    public Channel createChannel() throws IOException {
        RecoveryAwareChannelN ch = (RecoveryAwareChannelN)this.delegate.createChannel();
        if (ch == null) {
            return null;
        }
        return this.wrapChannel(ch);
    }

    @Override
    public Channel createChannel(int channelNumber) throws IOException {
        return this.delegate.createChannel(channelNumber);
    }

    private Channel wrapChannel(RecoveryAwareChannelN delegateChannel) {
        if (delegateChannel == null) {
            return null;
        }
        AutorecoveringChannel channel = new AutorecoveringChannel(this, delegateChannel);
        this.registerChannel(channel);
        return channel;
    }

    void registerChannel(AutorecoveringChannel channel) {
        this.channels.put(channel.getChannelNumber(), channel);
    }

    void unregisterChannel(AutorecoveringChannel channel) {
        this.channels.remove(channel.getChannelNumber());
    }

    @Override
    public Map<String, Object> getServerProperties() {
        return this.delegate.getServerProperties();
    }

    @Override
    public Map<String, Object> getClientProperties() {
        return this.delegate.getClientProperties();
    }

    @Override
    public String getClientProvidedName() {
        return this.delegate.getClientProvidedName();
    }

    @Override
    public int getFrameMax() {
        return this.delegate.getFrameMax();
    }

    @Override
    public int getHeartbeat() {
        return this.delegate.getHeartbeat();
    }

    @Override
    public int getChannelMax() {
        return this.delegate.getChannelMax();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int timeout) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int closeCode, String closeMessage, int timeout) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(closeCode, closeMessage, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int closeCode, String closeMessage, int timeout) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(closeCode, closeMessage, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int closeCode, String closeMessage) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(closeCode, closeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(int timeout) {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.abort(timeout);
    }

    public AMQConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public ShutdownSignalException getCloseReason() {
        return this.delegate.getCloseReason();
    }

    @Override
    public void addBlockedListener(BlockedListener listener) {
        this.blockedListeners.add(listener);
        this.delegate.addBlockedListener(listener);
    }

    @Override
    public BlockedListener addBlockedListener(final BlockedCallback blockedCallback, final UnblockedCallback unblockedCallback) {
        BlockedListener blockedListener = new BlockedListener(){

            @Override
            public void handleBlocked(String reason) throws IOException {
                blockedCallback.handle(reason);
            }

            @Override
            public void handleUnblocked() throws IOException {
                unblockedCallback.handle();
            }
        };
        this.addBlockedListener(blockedListener);
        return blockedListener;
    }

    @Override
    public boolean removeBlockedListener(BlockedListener listener) {
        this.blockedListeners.remove(listener);
        return this.delegate.removeBlockedListener(listener);
    }

    @Override
    public void clearBlockedListeners() {
        this.blockedListeners.clear();
        this.delegate.clearBlockedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        Object object = this.recoveryLock;
        synchronized (object) {
            this.manuallyClosed = true;
        }
        this.delegate.close(closeCode, closeMessage);
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.add(listener);
        this.delegate.addShutdownListener(listener);
    }

    @Override
    public void removeShutdownListener(ShutdownListener listener) {
        this.shutdownHooks.remove(listener);
        this.delegate.removeShutdownListener(listener);
    }

    @Override
    public void notifyListeners() {
        this.delegate.notifyListeners();
    }

    @Override
    public void addRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.add(listener);
    }

    @Override
    public void removeRecoveryListener(RecoveryListener listener) {
        this.recoveryListeners.remove(listener);
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.delegate.getExceptionHandler();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public InetAddress getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAutomaticRecoveryListener(RecoveryAwareAMQConnection newConn) {
        AutorecoveringConnection c = this;
        RecoveryCanBeginListener starter = cause -> {
            try {
                if (this.shouldTriggerConnectionRecovery(cause)) {
                    c.beginAutomaticRecovery();
                }
            }
            catch (Exception e) {
                newConn.getExceptionHandler().handleConnectionRecoveryException(c, e);
            }
        };
        AutorecoveringConnection autorecoveringConnection = this;
        synchronized (autorecoveringConnection) {
            newConn.addRecoveryCanBeginListener(starter);
        }
    }

    protected boolean shouldTriggerConnectionRecovery(ShutdownSignalException cause) {
        return this.connectionRecoveryTriggeringCondition.test(cause);
    }

    public void addQueueRecoveryListener(QueueRecoveryListener listener) {
        this.queueRecoveryListeners.add(listener);
    }

    public void removeQueueRecoveryListener(QueueRecoveryListener listener) {
        this.queueRecoveryListeners.remove(listener);
    }

    public void addConsumerRecoveryListener(ConsumerRecoveryListener listener) {
        this.consumerRecoveryListeners.add(listener);
    }

    public void removeConsumerRecoveryListener(ConsumerRecoveryListener listener) {
        this.consumerRecoveryListeners.remove(listener);
    }

    private synchronized void beginAutomaticRecovery() throws InterruptedException {
        this.wait(this.params.getRecoveryDelayHandler().getDelay(0));
        this.notifyRecoveryListenersStarted();
        RecoveryAwareAMQConnection newConn = this.recoverConnection();
        if (newConn == null) {
            return;
        }
        LOGGER.debug("Connection {} has recovered", (Object)newConn);
        this.addAutomaticRecoveryListener(newConn);
        this.recoverShutdownListeners(newConn);
        this.recoverBlockedListeners(newConn);
        this.recoverChannels(newConn);
        this.delegate = newConn;
        if (this.params.isTopologyRecoveryEnabled()) {
            this.recoverTopology(this.params.getTopologyRecoveryExecutor());
        }
        this.notifyRecoveryListenersComplete();
    }

    private void recoverShutdownListeners(RecoveryAwareAMQConnection newConn) {
        for (ShutdownListener sh : Utility.copy(this.shutdownHooks)) {
            newConn.addShutdownListener(sh);
        }
    }

    private void recoverBlockedListeners(RecoveryAwareAMQConnection newConn) {
        for (BlockedListener bl : Utility.copy(this.blockedListeners)) {
            newConn.addBlockedListener(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryAwareAMQConnection recoverConnection() throws InterruptedException {
        int attempts = 0;
        while (!this.manuallyClosed) {
            try {
                ++attempts;
                RecoveryAwareAMQConnection newConn = this.cf.newConnection();
                Object object = this.recoveryLock;
                synchronized (object) {
                    if (!this.manuallyClosed) {
                        return newConn;
                    }
                }
                newConn.abort();
                return null;
            }
            catch (Exception e) {
                Thread.sleep(this.params.getRecoveryDelayHandler().getDelay(attempts));
                this.getExceptionHandler().handleConnectionRecoveryException(this, e);
            }
        }
        return null;
    }

    private void recoverChannels(RecoveryAwareAMQConnection newConn) {
        for (AutorecoveringChannel ch : this.channels.values()) {
            try {
                ch.automaticallyRecover(this, newConn);
                LOGGER.debug("Channel {} has recovered", (Object)ch);
            }
            catch (Throwable t) {
                newConn.getExceptionHandler().handleChannelRecoveryException(ch, t);
            }
        }
    }

    void recoverChannel(AutorecoveringChannel channel) throws IOException {
        channel.automaticallyRecover(this, this.delegate);
    }

    private void notifyRecoveryListenersComplete() {
        for (RecoveryListener f : Utility.copy(this.recoveryListeners)) {
            f.handleRecovery(this);
        }
    }

    private void notifyRecoveryListenersStarted() {
        for (RecoveryListener f : Utility.copy(this.recoveryListeners)) {
            f.handleRecoveryStarted(this);
        }
    }

    private void recoverTopology(ExecutorService executor) {
        if (executor == null) {
            for (RecordedExchange recordedExchange : Utility.copy(this.recordedExchanges).values()) {
                this.recoverExchange(recordedExchange, true);
            }
            for (Map.Entry entry : Utility.copy(this.recordedQueues).entrySet()) {
                this.recoverQueue((String)entry.getKey(), (RecordedQueue)entry.getValue(), true);
            }
            for (RecordedBinding recordedBinding : Utility.copy(this.recordedBindings)) {
                this.recoverBinding(recordedBinding, true);
            }
            for (Map.Entry entry : Utility.copy(this.consumers).entrySet()) {
                this.recoverConsumer((String)entry.getKey(), (RecordedConsumer)entry.getValue(), true);
            }
        } else {
            try {
                this.recoverEntitiesAsynchronously(executor, Utility.copy(this.recordedExchanges).values());
                this.recoverEntitiesAsynchronously(executor, Utility.copy(this.recordedQueues).values());
                this.recoverEntitiesAsynchronously(executor, Utility.copy(this.recordedBindings));
                this.recoverEntitiesAsynchronously(executor, Utility.copy(this.consumers).values());
            }
            catch (Exception cause) {
                String string = "Caught an exception while recovering topology: " + cause.getMessage();
                TopologyRecoveryException e = new TopologyRecoveryException(string, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, null, e);
            }
        }
    }

    private void recoverExchange(RecordedExchange x, boolean retry) {
        try {
            if (this.topologyRecoveryFilter.filterExchange(x)) {
                if (retry) {
                    RecordedExchange entity = x;
                    x = (RecordedExchange)this.wrapRetryIfNecessary(x, () -> {
                        entity.recover();
                        return null;
                    }).getRecordedEntity();
                } else {
                    x.recover();
                }
                LOGGER.debug("{} has recovered", (Object)x);
            }
        }
        catch (Exception cause) {
            String message = "Caught an exception while recovering exchange " + x.getName() + ": " + cause.getMessage();
            TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
            this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, x.getDelegateChannel(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverQueue(String oldName, RecordedQueue q, boolean retry) {
        block10: {
            try {
                if (!this.topologyRecoveryFilter.filterQueue(q)) break block10;
                LOGGER.debug("Recovering {}", (Object)q);
                if (retry) {
                    RecordedQueue entity = q;
                    q = (RecordedQueue)this.wrapRetryIfNecessary(q, () -> {
                        entity.recover();
                        return null;
                    }).getRecordedEntity();
                } else {
                    q.recover();
                }
                String newName = q.getName();
                if (!oldName.equals(newName)) {
                    Map<String, RecordedQueue> map = this.recordedQueues;
                    synchronized (map) {
                        this.propagateQueueNameChangeToBindings(oldName, newName);
                        this.propagateQueueNameChangeToConsumers(oldName, newName);
                        if (q.isServerNamed()) {
                            this.deleteRecordedQueue(oldName);
                        }
                        this.recordedQueues.put(newName, q);
                    }
                }
                for (QueueRecoveryListener qrl : Utility.copy(this.queueRecoveryListeners)) {
                    qrl.queueRecovered(oldName, newName);
                }
                LOGGER.debug("{} has recovered", (Object)q);
            }
            catch (Exception cause) {
                String message = "Caught an exception while recovering queue " + oldName + ": " + cause.getMessage();
                TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, q.getDelegateChannel(), e);
            }
        }
    }

    private void recoverBinding(RecordedBinding b, boolean retry) {
        try {
            if (this.topologyRecoveryFilter.filterBinding(b)) {
                if (retry) {
                    RecordedBinding entity = b;
                    b = (RecordedBinding)this.wrapRetryIfNecessary(b, () -> {
                        entity.recover();
                        return null;
                    }).getRecordedEntity();
                } else {
                    b.recover();
                }
                LOGGER.debug("{} has recovered", (Object)b);
            }
        }
        catch (Exception cause) {
            String message = "Caught an exception while recovering binding between " + b.getSource() + " and " + b.getDestination() + ": " + cause.getMessage();
            TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
            this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, b.getDelegateChannel(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverConsumer(String tag, RecordedConsumer consumer, boolean retry) {
        block9: {
            try {
                Map<String, RecordedConsumer> entity;
                if (!this.topologyRecoveryFilter.filterConsumer(consumer)) break block9;
                LOGGER.debug("Recovering {}", (Object)consumer);
                String newTag = null;
                if (retry) {
                    entity = consumer;
                    RetryResult retryResult = this.wrapRetryIfNecessary(consumer, () -> AutorecoveringConnection.lambda$recoverConsumer$7((RecordedConsumer)((Object)entity)));
                    consumer = (RecordedConsumer)retryResult.getRecordedEntity();
                    newTag = (String)retryResult.getResult();
                } else {
                    newTag = consumer.recover();
                }
                if (tag != null && !tag.equals(newTag)) {
                    entity = this.consumers;
                    synchronized (entity) {
                        this.consumers.remove(tag);
                        this.consumers.put(newTag, consumer);
                    }
                    consumer.getChannel().updateConsumerTag(tag, newTag);
                }
                for (ConsumerRecoveryListener crl : Utility.copy(this.consumerRecoveryListeners)) {
                    crl.consumerRecovered(tag, newTag);
                }
                LOGGER.debug("{} has recovered", (Object)consumer);
            }
            catch (Exception cause) {
                String message = "Caught an exception while recovering consumer " + tag + ": " + cause.getMessage();
                TopologyRecoveryException e = new TopologyRecoveryException(message, cause);
                this.getExceptionHandler().handleTopologyRecoveryException(this.delegate, consumer.getDelegateChannel(), e);
            }
        }
    }

    private <T> RetryResult wrapRetryIfNecessary(RecordedEntity entity, Callable<T> recoveryAction) throws Exception {
        if (this.retryHandler == null) {
            T result = recoveryAction.call();
            return new RetryResult(entity, result);
        }
        try {
            T result = recoveryAction.call();
            return new RetryResult(entity, result);
        }
        catch (Exception e) {
            RetryResult retryResult;
            RetryContext retryContext = new RetryContext(entity, e, this);
            if (entity instanceof RecordedQueue) {
                retryResult = this.retryHandler.retryQueueRecovery(retryContext);
            } else if (entity instanceof RecordedExchange) {
                retryResult = this.retryHandler.retryExchangeRecovery(retryContext);
            } else if (entity instanceof RecordedBinding) {
                retryResult = this.retryHandler.retryBindingRecovery(retryContext);
            } else if (entity instanceof RecordedConsumer) {
                retryResult = this.retryHandler.retryConsumerRecovery(retryContext);
            } else {
                throw new IllegalArgumentException("Unknown type of recorded entity: " + entity);
            }
            return retryResult;
        }
    }

    private void propagateQueueNameChangeToBindings(String oldName, String newName) {
        for (RecordedBinding b : Utility.copy(this.recordedBindings)) {
            if (!b.getDestination().equals(oldName)) continue;
            b.setDestination(newName);
        }
    }

    private void propagateQueueNameChangeToConsumers(String oldName, String newName) {
        for (RecordedConsumer c : Utility.copy(this.consumers).values()) {
            if (!c.getQueue().equals(oldName)) continue;
            c.setQueue(newName);
        }
    }

    private void recoverEntitiesAsynchronously(ExecutorService executor, Collection<? extends RecordedEntity> recordedEntities) throws InterruptedException {
        List<Future<Object>> tasks = executor.invokeAll(this.groupEntitiesByChannel(recordedEntities));
        for (Future<Object> task : tasks) {
            if (!task.isDone()) {
                LOGGER.warn("Recovery task should be done {}", (Object)task);
                continue;
            }
            try {
                task.get(1L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOGGER.warn("Recovery task is done but returned an exception", e);
            }
        }
    }

    private <E extends RecordedEntity> List<Callable<Object>> groupEntitiesByChannel(Collection<E> entities) {
        LinkedHashMap<AutorecoveringChannel, ArrayList<RecordedEntity>> map = new LinkedHashMap<AutorecoveringChannel, ArrayList<RecordedEntity>>();
        for (RecordedEntity entity : entities) {
            AutorecoveringChannel channel = entity.getChannel();
            ArrayList<RecordedEntity> list = (ArrayList<RecordedEntity>)map.get(channel);
            if (list == null) {
                list = new ArrayList<RecordedEntity>();
                map.put(channel, list);
            }
            list.add(entity);
        }
        ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>();
        for (List entityList : map.values()) {
            callables.add(Executors.callable(() -> {
                for (RecordedEntity entity : entityList) {
                    if (entity instanceof RecordedExchange) {
                        this.recoverExchange((RecordedExchange)entity, true);
                        continue;
                    }
                    if (entity instanceof RecordedQueue) {
                        RecordedQueue q = (RecordedQueue)entity;
                        this.recoverQueue(q.getName(), q, true);
                        continue;
                    }
                    if (entity instanceof RecordedBinding) {
                        this.recoverBinding((RecordedBinding)entity, true);
                        continue;
                    }
                    if (!(entity instanceof RecordedConsumer)) continue;
                    RecordedConsumer c = (RecordedConsumer)entity;
                    this.recoverConsumer(c.getConsumerTag(), c, true);
                }
            }));
        }
        return callables;
    }

    void recordQueueBinding(AutorecoveringChannel ch, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        RecordedBinding binding = new RecordedQueueBinding(ch).source(exchange).destination(queue).routingKey(routingKey).arguments(arguments);
        this.recordedBindings.remove(binding);
        this.recordedBindings.add(binding);
    }

    boolean deleteRecordedQueueBinding(AutorecoveringChannel ch, String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        RecordedBinding b = new RecordedQueueBinding(ch).source(exchange).destination(queue).routingKey(routingKey).arguments(arguments);
        return this.recordedBindings.remove(b);
    }

    void recordExchangeBinding(AutorecoveringChannel ch, String destination, String source, String routingKey, Map<String, Object> arguments) {
        RecordedBinding binding = new RecordedExchangeBinding(ch).source(source).destination(destination).routingKey(routingKey).arguments(arguments);
        this.recordedBindings.remove(binding);
        this.recordedBindings.add(binding);
    }

    boolean deleteRecordedExchangeBinding(AutorecoveringChannel ch, String destination, String source, String routingKey, Map<String, Object> arguments) {
        RecordedBinding b = new RecordedExchangeBinding(ch).source(source).destination(destination).routingKey(routingKey).arguments(arguments);
        return this.recordedBindings.remove(b);
    }

    void recordQueue(AMQP.Queue.DeclareOk ok, RecordedQueue q) {
        this.recordedQueues.put(ok.getQueue(), q);
    }

    void recordQueue(String queue, RecordedQueue meta) {
        this.recordedQueues.put(queue, meta);
    }

    void deleteRecordedQueue(String queue) {
        this.recordedQueues.remove(queue);
        Set<RecordedBinding> xs = this.removeBindingsWithDestination(queue);
        for (RecordedBinding b : xs) {
            this.maybeDeleteRecordedAutoDeleteExchange(b.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excludeQueueFromRecovery(String queue, boolean ifUnused) {
        if (ifUnused) {
            Map<String, RecordedConsumer> map = this.consumers;
            synchronized (map) {
                Map<String, RecordedQueue> map2 = this.recordedQueues;
                synchronized (map2) {
                    if (!this.hasMoreConsumersOnQueue(this.consumers.values(), queue)) {
                        this.deleteRecordedQueue(queue);
                    }
                }
            }
        }
        this.deleteRecordedQueue(queue);
    }

    void recordExchange(String exchange, RecordedExchange x) {
        this.recordedExchanges.put(exchange, x);
    }

    void deleteRecordedExchange(String exchange) {
        this.recordedExchanges.remove(exchange);
        Set<RecordedBinding> xs = this.removeBindingsWithDestination(exchange);
        for (RecordedBinding b : xs) {
            this.maybeDeleteRecordedAutoDeleteExchange(b.getSource());
        }
    }

    void recordConsumer(String result, RecordedConsumer consumer) {
        this.consumers.put(result, consumer);
    }

    RecordedConsumer deleteRecordedConsumer(String consumerTag) {
        return this.consumers.remove(consumerTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeDeleteRecordedAutoDeleteQueue(String queue) {
        Map<String, RecordedConsumer> map = this.consumers;
        synchronized (map) {
            Map<String, RecordedQueue> map2 = this.recordedQueues;
            synchronized (map2) {
                RecordedQueue q;
                if (!this.hasMoreConsumersOnQueue(this.consumers.values(), queue) && (q = this.recordedQueues.get(queue)) != null && q.isAutoDelete()) {
                    this.deleteRecordedQueue(queue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeDeleteRecordedAutoDeleteExchange(String exchange) {
        Map<String, RecordedConsumer> map = this.consumers;
        synchronized (map) {
            Map<String, RecordedExchange> map2 = this.recordedExchanges;
            synchronized (map2) {
                RecordedExchange x;
                if (!this.hasMoreDestinationsBoundToExchange(Utility.copy(this.recordedBindings), exchange) && (x = this.recordedExchanges.get(exchange)) != null && x.isAutoDelete()) {
                    this.deleteRecordedExchange(exchange);
                }
            }
        }
    }

    boolean hasMoreDestinationsBoundToExchange(List<RecordedBinding> bindings, String exchange) {
        boolean result = false;
        for (RecordedBinding b : bindings) {
            if (!exchange.equals(b.getSource())) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean hasMoreConsumersOnQueue(Collection<RecordedConsumer> consumers, String queue) {
        boolean result = false;
        for (RecordedConsumer c : consumers) {
            if (!queue.equals(c.getQueue())) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<RecordedBinding> removeBindingsWithDestination(String s) {
        HashSet<RecordedBinding> result = new HashSet<RecordedBinding>();
        List<RecordedBinding> list = this.recordedBindings;
        synchronized (list) {
            Iterator<RecordedBinding> it = this.recordedBindings.iterator();
            while (it.hasNext()) {
                RecordedBinding b = it.next();
                if (!b.getDestination().equals(s)) continue;
                it.remove();
                result.add(b);
            }
        }
        return result;
    }

    public Map<String, RecordedQueue> getRecordedQueues() {
        return this.recordedQueues;
    }

    public Map<String, RecordedExchange> getRecordedExchanges() {
        return this.recordedExchanges;
    }

    public List<RecordedBinding> getRecordedBindings() {
        return this.recordedBindings;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public void setId(String id) {
        this.delegate.setId(id);
    }

    private static /* synthetic */ String lambda$recoverConsumer$7(RecordedConsumer entity) throws Exception {
        return entity.recover();
    }
}

