/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.stream.ChunkInputStream;
import org.duracloud.chunk.stream.CountingDigestInputStream;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkableContent
implements Iterable<ChunkInputStream>,
Iterator<ChunkInputStream> {
    private final Logger log = LoggerFactory.getLogger(ChunkableContent.class);
    private CountingDigestInputStream largeStream;
    private String contentId;
    private long maxChunkSize;
    private long contentSize;
    private ChunkInputStream currentChunk;
    private ChunksManifest manifest;
    private long bytesRead;
    private boolean preserveChunkMD5s = false;
    private static final String DEFAULT_MIME = "application/octet-stream";
    private final int BUFFER_SIZE;

    public ChunkableContent(String contentId, InputStream largeStream, long contentSize, long maxChunkSize) {
        this(contentId, DEFAULT_MIME, largeStream, contentSize, maxChunkSize);
    }

    public ChunkableContent(String contentId, String contentMimetype, InputStream largeStream, long contentSize, long maxChunkSize) {
        this.BUFFER_SIZE = this.calculateBufferSize(maxChunkSize);
        this.contentId = contentId;
        this.largeStream = new CountingDigestInputStream(largeStream, true);
        this.maxChunkSize = maxChunkSize;
        this.contentSize = contentSize;
        this.currentChunk = null;
        this.bytesRead = 0L;
        this.manifest = new ChunksManifest(this.contentId, contentMimetype, contentSize);
    }

    private int calculateBufferSize(long maxChunkSize) {
        long size;
        int KB = 1000;
        if (maxChunkSize % 1000L != 0L) {
            String m = "MaxChunkSize must be multiple of 1000: " + maxChunkSize;
            this.log.error(m);
            throw new DuraCloudRuntimeException(m);
        }
        for (size = maxChunkSize; size > 8000L; size /= 2L) {
        }
        this.log.debug("Buf size: " + size + " for maxChunkSize: " + maxChunkSize);
        return (int)size;
    }

    @Override
    public boolean hasNext() {
        return null == this.currentChunk || this.currentChunk.numBytesRead() + this.bytesRead < this.contentSize;
    }

    @Override
    public ChunkInputStream next() {
        this.throwIfChunkNotFullyRead();
        this.addEntry();
        long chunkSize = this.calculateNextChunkSize();
        String chunkId = this.manifest.nextChunkId();
        BufferedInputStream buffIS = new BufferedInputStream(this.largeStream, this.BUFFER_SIZE);
        this.currentChunk = new ChunkInputStream(chunkId, buffIS, chunkSize, this.preserveChunkMD5s);
        return this.currentChunk;
    }

    private void addEntry() {
        if (null != this.currentChunk) {
            this.manifest.addEntry(this.currentChunk.getChunkId(), this.currentChunk.getMD5(), this.currentChunk.numBytesRead());
            this.bytesRead += this.currentChunk.numBytesRead();
        } else {
            this.log.debug("currentChunk is null. No entry added.");
        }
    }

    private long calculateNextChunkSize() {
        long nextSize = this.contentSize - this.bytesRead;
        if (nextSize > this.maxChunkSize) {
            nextSize = this.maxChunkSize;
        }
        return nextSize;
    }

    private void throwIfChunkNotFullyRead() {
        if (null != this.currentChunk && this.currentChunk.numBytesRead() < this.currentChunk.getChunkSize()) {
            StringBuilder sb = new StringBuilder("Error: ");
            sb.append("Previous chunk not fully read: ");
            sb.append(this.currentChunk.getChunkId());
            this.log.error(sb.toString());
            throw new DuraCloudRuntimeException(sb.toString());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported.");
    }

    @Override
    public Iterator<ChunkInputStream> iterator() {
        return this;
    }

    public void setPreserveChunkMD5s(boolean preserveChunkMD5s) {
        this.preserveChunkMD5s = preserveChunkMD5s;
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public ChunksManifest getManifest() {
        return this.manifest;
    }

    public ChunksManifest finalizeManifest() {
        this.addEntry();
        this.manifest.setMD5OfSourceContent(this.largeStream.getMD5());
        IOUtils.closeQuietly(this.largeStream);
        return this.manifest;
    }
}

