/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.TaggedResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeTagsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<TaggedResource> taggedResources;
    private String marker;

    public List<TaggedResource> getTaggedResources() {
        if (this.taggedResources == null) {
            this.taggedResources = new ListWithAutoConstructFlag();
            this.taggedResources.setAutoConstruct(true);
        }
        return this.taggedResources;
    }

    public void setTaggedResources(Collection<TaggedResource> taggedResources) {
        if (taggedResources == null) {
            this.taggedResources = null;
            return;
        }
        ListWithAutoConstructFlag taggedResourcesCopy = new ListWithAutoConstructFlag(taggedResources.size());
        taggedResourcesCopy.addAll(taggedResources);
        this.taggedResources = taggedResourcesCopy;
    }

    public DescribeTagsResult withTaggedResources(TaggedResource ... taggedResources) {
        if (this.getTaggedResources() == null) {
            this.setTaggedResources(new ArrayList<TaggedResource>(taggedResources.length));
        }
        for (TaggedResource value : taggedResources) {
            this.getTaggedResources().add(value);
        }
        return this;
    }

    public DescribeTagsResult withTaggedResources(Collection<TaggedResource> taggedResources) {
        if (taggedResources == null) {
            this.taggedResources = null;
        } else {
            ListWithAutoConstructFlag taggedResourcesCopy = new ListWithAutoConstructFlag(taggedResources.size());
            taggedResourcesCopy.addAll(taggedResources);
            this.taggedResources = taggedResourcesCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeTagsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaggedResources() != null) {
            sb.append("TaggedResources: " + this.getTaggedResources() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaggedResources() == null ? 0 : this.getTaggedResources().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResult)) {
            return false;
        }
        DescribeTagsResult other = (DescribeTagsResult)obj;
        if (other.getTaggedResources() == null ^ this.getTaggedResources() == null) {
            return false;
        }
        if (other.getTaggedResources() != null && !other.getTaggedResources().equals(this.getTaggedResources())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public DescribeTagsResult clone() {
        try {
            return (DescribeTagsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

