/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeFlowLogsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeFlowLogsRequestMarshaller
implements Marshaller<Request<DescribeFlowLogsRequest>, DescribeFlowLogsRequest> {
    @Override
    public Request<DescribeFlowLogsRequest> marshall(DescribeFlowLogsRequest describeFlowLogsRequest) {
        if (describeFlowLogsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFlowLogsRequest> request = new DefaultRequest<DescribeFlowLogsRequest>(describeFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFlowLogs");
        request.addParameter("Version", "2015-04-15");
        List<String> flowLogIdsList = describeFlowLogsRequest.getFlowLogIds();
        int flowLogIdsListIndex = 1;
        for (String flowLogIdsListValue : flowLogIdsList) {
            if (flowLogIdsListValue != null) {
                request.addParameter("FlowLogId." + flowLogIdsListIndex, StringUtils.fromString(flowLogIdsListValue));
            }
            ++flowLogIdsListIndex;
        }
        List<Filter> filterList = describeFlowLogsRequest.getFilter();
        int filterListIndex = 1;
        for (Filter filterListValue : filterList) {
            Filter filterMember = filterListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filterListIndex;
        }
        if (describeFlowLogsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeFlowLogsRequest.getNextToken()));
        }
        if (describeFlowLogsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeFlowLogsRequest.getMaxResults()));
        }
        return request;
    }
}

