/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.json.JSONWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class AttributeValueJsonMarshaller {
    private static AttributeValueJsonMarshaller instance;

    public void marshall(AttributeValue attributeValue, JSONWriter jsonWriter) {
        if (attributeValue == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeValue> lList;
            Map<String, AttributeValue> mMap;
            List<ByteBuffer> bSList;
            List<String> nSList;
            List<String> sSList;
            jsonWriter.object();
            if (attributeValue.getS() != null) {
                jsonWriter.key("S").value(attributeValue.getS());
            }
            if (attributeValue.getN() != null) {
                jsonWriter.key("N").value(attributeValue.getN());
            }
            if (attributeValue.getB() != null) {
                jsonWriter.key("B").value(attributeValue.getB());
            }
            if ((sSList = attributeValue.getSS()) != null) {
                jsonWriter.key("SS");
                jsonWriter.array();
                for (String sSListValue : sSList) {
                    if (sSListValue == null) continue;
                    jsonWriter.value(sSListValue);
                }
                jsonWriter.endArray();
            }
            if ((nSList = attributeValue.getNS()) != null) {
                jsonWriter.key("NS");
                jsonWriter.array();
                for (String nSListValue : nSList) {
                    if (nSListValue == null) continue;
                    jsonWriter.value(nSListValue);
                }
                jsonWriter.endArray();
            }
            if ((bSList = attributeValue.getBS()) != null) {
                jsonWriter.key("BS");
                jsonWriter.array();
                for (ByteBuffer bSListValue : bSList) {
                    if (bSListValue == null) continue;
                    jsonWriter.value(bSListValue);
                }
                jsonWriter.endArray();
            }
            if ((mMap = attributeValue.getM()) != null) {
                jsonWriter.key("M");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> mMapValue : mMap.entrySet()) {
                    if (mMapValue.getValue() == null) continue;
                    jsonWriter.key(mMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(mMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            if ((lList = attributeValue.getL()) != null) {
                jsonWriter.key("L");
                jsonWriter.array();
                for (AttributeValue lListValue : lList) {
                    if (lListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(lListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (attributeValue.getNULL() != null) {
                jsonWriter.key("NULL").value(attributeValue.getNULL());
            }
            if (attributeValue.getBOOL() != null) {
                jsonWriter.key("BOOL").value(attributeValue.getBOOL());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeValueJsonMarshaller();
        }
        return instance;
    }
}

