/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.TagResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTagsForResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceType;
    private ListWithAutoConstructFlag<String> resourceIds;

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public ListTagsForResourcesRequest withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public void setResourceType(TagResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public ListTagsForResourcesRequest withResourceType(TagResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<String> getResourceIds() {
        if (this.resourceIds == null) {
            this.resourceIds = new ListWithAutoConstructFlag();
            this.resourceIds.setAutoConstruct(true);
        }
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        ListWithAutoConstructFlag resourceIdsCopy = new ListWithAutoConstructFlag(resourceIds.size());
        resourceIdsCopy.addAll(resourceIds);
        this.resourceIds = resourceIdsCopy;
    }

    public ListTagsForResourcesRequest withResourceIds(String ... resourceIds) {
        if (this.getResourceIds() == null) {
            this.setResourceIds(new ArrayList<String>(resourceIds.length));
        }
        for (String value : resourceIds) {
            this.getResourceIds().add(value);
        }
        return this;
    }

    public ListTagsForResourcesRequest withResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
        } else {
            ListWithAutoConstructFlag resourceIdsCopy = new ListWithAutoConstructFlag(resourceIds.size());
            resourceIdsCopy.addAll(resourceIds);
            this.resourceIds = resourceIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: " + this.getResourceType() + ",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: " + this.getResourceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesRequest)) {
            return false;
        }
        ListTagsForResourcesRequest other = (ListTagsForResourcesRequest)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        return other.getResourceIds() == null || other.getResourceIds().equals(this.getResourceIds());
    }

    @Override
    public ListTagsForResourcesRequest clone() {
        return (ListTagsForResourcesRequest)super.clone();
    }
}

