/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.auth.policy.actions.SQSActions;
import com.amazonaws.auth.policy.conditions.ConditionFactory;
import com.amazonaws.services.glacier.model.StatusCode;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStatusMonitor {
    private AmazonSQSClient sqs;
    private AmazonSNSClient sns;
    private String queueUrl;
    private String topicArn;
    private static final Log log = LogFactory.getLog(JobStatusMonitor.class);

    public JobStatusMonitor(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this.sqs = new AmazonSQSClient(credentialsProvider, clientConfiguration);
        this.sns = new AmazonSNSClient(credentialsProvider, clientConfiguration);
        this.setupQueueAndTopic();
    }

    public JobStatusMonitor(AmazonSQSClient sqs, AmazonSNSClient sns) {
        this.sqs = sqs;
        this.sns = sns;
        this.setupQueueAndTopic();
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void shutdown() {
        try {
            this.sqs.deleteQueue(new DeleteQueueRequest(this.queueUrl));
        }
        catch (Exception e) {
            log.warn("Unable to delete queue: " + this.queueUrl, e);
        }
        try {
            this.sns.deleteTopic(new DeleteTopicRequest(this.topicArn));
        }
        catch (Exception e) {
            log.warn("Unable to delete topic: " + this.topicArn, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobToComplete(String jobId) {
        while (true) {
            List<Message> messages = this.sqs.receiveMessage(new ReceiveMessageRequest(this.queueUrl)).getMessages();
            for (Message message : messages) {
                String messageBody = message.getBody();
                if (!messageBody.startsWith("{")) {
                    messageBody = new String(BinaryUtils.fromBase64(messageBody));
                }
                try {
                    JSONObject json = new JSONObject(messageBody);
                    String jsonMessage = json.getString("Message").replace("\\\"", "\"");
                    json = new JSONObject(jsonMessage);
                    String messageJobId = json.getString("JobId");
                    String messageStatus = json.getString("StatusMessage");
                    if (!jobId.equals(messageJobId)) continue;
                    try {
                        if (StatusCode.Succeeded.toString().equals(messageStatus)) {
                            return;
                        }
                        if (!StatusCode.Failed.toString().equals(messageStatus)) continue;
                        throw new AmazonClientException("Archive retrieval failed");
                    }
                    finally {
                        this.deleteMessage(message);
                    }
                }
                catch (JSONException e) {
                    throw new AmazonClientException("Unable to parse status message: " + messageBody, e);
                }
            }
            this.sleep(30000L);
        }
    }

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ie) {
            throw new AmazonClientException("Archive download interrupted", ie);
        }
    }

    private void deleteMessage(Message message) {
        try {
            this.sqs.deleteMessage(new DeleteMessageRequest(this.queueUrl, message.getReceiptHandle()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupQueueAndTopic() {
        String randomSeed = UUID.randomUUID().toString();
        String queueName = "glacier-archive-transfer-" + randomSeed;
        String topicName = "glacier-archive-transfer-" + randomSeed;
        this.queueUrl = this.sqs.createQueue(new CreateQueueRequest(queueName)).getQueueUrl();
        this.topicArn = this.sns.createTopic(new CreateTopicRequest(topicName)).getTopicArn();
        String queueARN = this.sqs.getQueueAttributes(new GetQueueAttributesRequest(this.queueUrl).withAttributeNames("QueueArn")).getAttributes().get("QueueArn");
        Policy sqsPolicy = new Policy().withStatements(new Statement(Statement.Effect.Allow).withPrincipals(Principal.AllUsers).withActions(SQSActions.SendMessage).withResources(new Resource(queueARN)).withConditions(ConditionFactory.newSourceArnCondition(this.topicArn)));
        this.sqs.setQueueAttributes(new SetQueueAttributesRequest(this.queueUrl, this.newAttributes("Policy", sqsPolicy.toJson())));
        this.sns.subscribe(new SubscribeRequest(this.topicArn, "sqs", queueARN));
    }

    private Map<String, String> newAttributes(String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Incorrect number of arguments passed.  Input must be specified as: key, value, key, value, ...");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            String key = keyValuePairs[i];
            String value = keyValuePairs[i + 1];
            map.put(key, value);
        }
        return map;
    }
}

