/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.SingleInstanceHealth;
import com.amazonaws.services.elasticbeanstalk.model.transform.ApplicationMetricsStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.SystemStatusStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SingleInstanceHealthStaxUnmarshaller
implements Unmarshaller<SingleInstanceHealth, StaxUnmarshallerContext> {
    private static SingleInstanceHealthStaxUnmarshaller instance;

    @Override
    public SingleInstanceHealth unmarshall(StaxUnmarshallerContext context) throws Exception {
        SingleInstanceHealth singleInstanceHealth = new SingleInstanceHealth();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return singleInstanceHealth;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("InstanceId", targetDepth)) {
                    singleInstanceHealth.setInstanceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthStatus", targetDepth)) {
                    singleInstanceHealth.setHealthStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Color", targetDepth)) {
                    singleInstanceHealth.setColor(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Causes/member", targetDepth)) {
                    singleInstanceHealth.getCauses().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LaunchedAt", targetDepth)) {
                    singleInstanceHealth.setLaunchedAt(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ApplicationMetrics", targetDepth)) {
                    singleInstanceHealth.setApplicationMetrics(ApplicationMetricsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("System", targetDepth)) continue;
                singleInstanceHealth.setSystem(SystemStatusStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return singleInstanceHealth;
    }

    public static SingleInstanceHealthStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SingleInstanceHealthStaxUnmarshaller();
        }
        return instance;
    }
}

