/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ExpectedAttributeValueJsonMarshaller {
    private static ExpectedAttributeValueJsonMarshaller instance;

    public void marshall(ExpectedAttributeValue expectedAttributeValue, JSONWriter jsonWriter) {
        if (expectedAttributeValue == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeValue> attributeValueListList;
            jsonWriter.object();
            if (expectedAttributeValue.getValue() != null) {
                jsonWriter.key("Value");
                AttributeValueJsonMarshaller.getInstance().marshall(expectedAttributeValue.getValue(), jsonWriter);
            }
            if (expectedAttributeValue.getExists() != null) {
                jsonWriter.key("Exists").value(expectedAttributeValue.getExists());
            }
            if (expectedAttributeValue.getComparisonOperator() != null) {
                jsonWriter.key("ComparisonOperator").value(expectedAttributeValue.getComparisonOperator());
            }
            if ((attributeValueListList = expectedAttributeValue.getAttributeValueList()) != null) {
                jsonWriter.key("AttributeValueList");
                jsonWriter.array();
                for (AttributeValue attributeValueListListValue : attributeValueListList) {
                    if (attributeValueListListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ExpectedAttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ExpectedAttributeValueJsonMarshaller();
        }
        return instance;
    }
}

