/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.ListDeploymentInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListDeploymentInstancesRequestMarshaller
implements Marshaller<Request<ListDeploymentInstancesRequest>, ListDeploymentInstancesRequest> {
    @Override
    public Request<ListDeploymentInstancesRequest> marshall(ListDeploymentInstancesRequest listDeploymentInstancesRequest) {
        if (listDeploymentInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDeploymentInstancesRequest> request = new DefaultRequest<ListDeploymentInstancesRequest>(listDeploymentInstancesRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.ListDeploymentInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList instanceStatusFilterList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listDeploymentInstancesRequest.getDeploymentId() != null) {
                jsonWriter.key("deploymentId").value(listDeploymentInstancesRequest.getDeploymentId());
            }
            if (listDeploymentInstancesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listDeploymentInstancesRequest.getNextToken());
            }
            if (!(instanceStatusFilterList = (SdkInternalList)listDeploymentInstancesRequest.getInstanceStatusFilter()).isEmpty() || !instanceStatusFilterList.isAutoConstruct()) {
                jsonWriter.key("instanceStatusFilter");
                jsonWriter.array();
                for (String instanceStatusFilterListValue : instanceStatusFilterList) {
                    if (instanceStatusFilterListValue == null) continue;
                    jsonWriter.value(instanceStatusFilterListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

