/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.LifecycleEvent;
import com.amazonaws.services.codedeploy.model.transform.DiagnosticsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class LifecycleEventJsonMarshaller {
    private static LifecycleEventJsonMarshaller instance;

    public void marshall(LifecycleEvent lifecycleEvent, JSONWriter jsonWriter) {
        if (lifecycleEvent == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (lifecycleEvent.getLifecycleEventName() != null) {
                jsonWriter.key("lifecycleEventName").value(lifecycleEvent.getLifecycleEventName());
            }
            if (lifecycleEvent.getDiagnostics() != null) {
                jsonWriter.key("diagnostics");
                DiagnosticsJsonMarshaller.getInstance().marshall(lifecycleEvent.getDiagnostics(), jsonWriter);
            }
            if (lifecycleEvent.getStartTime() != null) {
                jsonWriter.key("startTime").value(lifecycleEvent.getStartTime());
            }
            if (lifecycleEvent.getEndTime() != null) {
                jsonWriter.key("endTime").value(lifecycleEvent.getEndTime());
            }
            if (lifecycleEvent.getStatus() != null) {
                jsonWriter.key("status").value(lifecycleEvent.getStatus());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LifecycleEventJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LifecycleEventJsonMarshaller();
        }
        return instance;
    }
}

