/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;

public class FlowUtils {
    private static Logger log = Logger.getLogger(FlowUtils.class);
    private static final String DSPACE_SUBMISSION_INFO = "dspace.submission.info";

    public static InProgressSubmission findSubmission(Context context, String inProgressSubmissionID) throws SQLException {
        char type = inProgressSubmissionID.charAt(0);
        int id = Integer.valueOf(inProgressSubmissionID.substring(1));
        if (type == 'S') {
            return WorkspaceItem.find((Context)context, (int)id);
        }
        if (type == 'W') {
            return WorkflowItem.find((Context)context, (int)id);
        }
        return null;
    }

    public static WorkspaceItem findWorkspace(Context context, String inProgressSubmissionID) throws SQLException {
        InProgressSubmission submission = FlowUtils.findSubmission(context, inProgressSubmissionID);
        if (submission instanceof WorkspaceItem) {
            return (WorkspaceItem)submission;
        }
        return null;
    }

    public static WorkflowItem findWorkflow(Context context, String inProgressSubmissionID) throws SQLException {
        InProgressSubmission submission = FlowUtils.findSubmission(context, inProgressSubmissionID);
        if (submission instanceof WorkflowItem) {
            return (WorkflowItem)submission;
        }
        return null;
    }

    public static SubmissionInfo obtainSubmissionInfo(Map objectModel, String workspaceID) throws SQLException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = ContextUtil.obtainContext(objectModel);
        SubmissionInfo subInfo = (SubmissionInfo)request.getAttribute(DSPACE_SUBMISSION_INFO);
        InProgressSubmission submission = FlowUtils.findSubmission(context, workspaceID);
        if (subInfo == null && submission != null || subInfo != null && submission != null && subInfo.getSubmissionItem().getID() != submission.getID()) {
            try {
                HttpServletRequest httpRequest = (HttpServletRequest)objectModel.get("httprequest");
                subInfo = SubmissionInfo.load((HttpServletRequest)httpRequest, (InProgressSubmission)submission);
                context.setExtraLogInfo("session_id=" + request.getSession().getId());
                request.setAttribute(DSPACE_SUBMISSION_INFO, (Object)subInfo);
            }
            catch (Exception e) {
                throw new SQLException("Error loading Submission Info: " + e.getMessage());
            }
        } else if (subInfo == null && submission == null) {
            throw new SQLException("Unable to load Submission Information, since WorkspaceID (ID:" + workspaceID + ") is not a valid in-process submission.");
        }
        return subInfo;
    }

    public static void setPageReached(Context context, String id, int step, int page) throws SQLException, AuthorizeException, IOException {
        InProgressSubmission submission = FlowUtils.findSubmission(context, id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            if (step > workspaceItem.getStageReached()) {
                workspaceItem.setStageReached(step);
                workspaceItem.setPageReached(1);
                workspaceItem.update();
                context.commit();
            } else if (step == workspaceItem.getStageReached() && page > workspaceItem.getPageReached()) {
                workspaceItem.setPageReached(page);
                workspaceItem.update();
                context.commit();
            }
        }
    }

    public static void setBackPageReached(Context context, String id, int step, int page) throws SQLException, AuthorizeException, IOException {
        InProgressSubmission submission = FlowUtils.findSubmission(context, id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            workspaceItem.setStageReached(step);
            workspaceItem.setPageReached(page > 0 ? page : 1);
            workspaceItem.update();
            context.commit();
        }
    }

    public static int getMaximumStepReached(Context context, String id) throws SQLException {
        InProgressSubmission submission = FlowUtils.findSubmission(context, id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            int stage = workspaceItem.getStageReached();
            if (stage < 0) {
                stage = 0;
            }
            return stage;
        }
        return Integer.MAX_VALUE;
    }

    public static int getMaximumPageReached(Context context, String id) throws SQLException {
        InProgressSubmission submission = FlowUtils.findSubmission(context, id);
        if (submission instanceof WorkspaceItem) {
            WorkspaceItem workspaceItem = (WorkspaceItem)submission;
            int page = workspaceItem.getPageReached();
            if (page < 0) {
                page = 0;
            }
            return page;
        }
        return Integer.MAX_VALUE;
    }

    public static int getStep(double stepAndPage) {
        String[] fields = Double.toString(stepAndPage).split("\\.");
        return Integer.parseInt(fields[0]);
    }

    public static int getPage(double stepAndPage) {
        String[] fields = Double.toString(stepAndPage).split("\\.");
        return Integer.parseInt(fields[1]);
    }

    public static void processSaveOrRemove(Context context, String id, Request request) throws SQLException, AuthorizeException, IOException {
        if (request.getParameter("submit_remove") != null) {
            WorkspaceItem workspace = FlowUtils.findWorkspace(context, id);
            workspace.deleteAll();
            context.commit();
        }
    }

    public static boolean processApproveTask(Context context, String id) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow(context, id);
        Item item = workflowItem.getItem();
        WorkflowManager.advance((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
        String handle = HandleManager.findHandle((Context)context, (DSpaceObject)item);
        context.commit();
        return handle != null;
    }

    public static void processUnclaimTask(Context context, String id) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow(context, id);
        WorkflowManager.unclaim((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
        context.commit();
        log.info((Object)LogManager.getHeader((Context)context, (String)"unclaim_workflow", (String)("workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",new_state=" + workflowItem.getState())));
    }

    public static void processClaimTask(Context context, String id) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow(context, id);
        WorkflowManager.claim((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
        context.commit();
        log.info((Object)LogManager.getHeader((Context)context, (String)"claim_task", (String)("workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "newowner_id=" + workflowItem.getOwner().getID() + "new_state=" + workflowItem.getState())));
    }

    public static String processRejectTask(Context context, String id, Request request) throws SQLException, UIException, ServletException, AuthorizeException, IOException {
        WorkflowItem workflowItem = FlowUtils.findWorkflow(context, id);
        String reason = request.getParameter("reason");
        if (reason != null && reason.length() > 1) {
            WorkspaceItem wsi = WorkflowManager.reject((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser(), (String)reason);
            Collection c = wsi.getCollection();
            SubmissionConfigReader subConfigReader = new SubmissionConfigReader();
            SubmissionConfig subConfig = subConfigReader.getSubmissionConfig(c.getHandle(), false);
            int lastStep = subConfig.getNumberOfSteps() - 2;
            wsi.setStageReached(lastStep);
            wsi.setPageReached(AbstractProcessingStep.LAST_PAGE_REACHED);
            wsi.update();
            context.commit();
            log.info((Object)LogManager.getHeader((Context)context, (String)"reject_workflow", (String)("workflow_item_id=" + wsi.getID() + "item_id=" + wsi.getItem().getID() + "collection_id=" + wsi.getCollection().getID() + "eperson_id=" + context.getCurrentUser().getID())));
            return null;
        }
        return "reason";
    }

    public static String getFieldName(DCInput input) {
        String dcSchema = input.getSchema();
        String dcElement = input.getElement();
        String dcQualifier = input.getQualifier();
        if (dcQualifier != null && !dcQualifier.equals("*")) {
            return dcSchema + "_" + dcElement + '_' + dcQualifier;
        }
        return dcSchema + "_" + dcElement;
    }

    public static Double[] getListOfAllSteps(HttpServletRequest request, SubmissionInfo subInfo) {
        ArrayList<Double> listStepNumbers = new ArrayList<Double>();
        for (int i = 0; i < subInfo.getSubmissionConfig().getNumberOfSteps(); ++i) {
            SubmissionStepConfig currentStep = subInfo.getSubmissionConfig().getStep(i);
            String stepNumber = Integer.toString(currentStep.getStepNumber());
            if (currentStep.getId() != null && currentStep.getId().equals(SubmissionStepConfig.SELECT_COLLECTION_STEP)) continue;
            int numPages = 1;
            try {
                ClassLoader loader = subInfo.getClass().getClassLoader();
                Class<?> stepClass = loader.loadClass(currentStep.getProcessingClassName());
                AbstractProcessingStep step = (AbstractProcessingStep)stepClass.newInstance();
                numPages = step.getNumberOfPages(request, subInfo);
            }
            catch (Exception e) {
                log.error((Object)("Error loading step information from Step Class '" + currentStep.getProcessingClassName() + "' Error:"), (Throwable)e);
            }
            for (int j = 1; j <= numPages; ++j) {
                String stepAndPage = stepNumber + "." + j;
                Double stepAndPageNum = Double.valueOf(stepAndPage);
                listStepNumbers.add(stepAndPageNum);
            }
        }
        return listStepNumbers.toArray(new Double[listStepNumbers.size()]);
    }
}

