/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.artifactbrowser.AbstractSearch;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSearch
extends AbstractSearch
implements CacheableProcessingComponent {
    private static final Message T_title = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.title");
    private static final Message T_dspace_home = SimpleSearch.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.trail");
    private static final Message T_head = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.head");
    private static final Message T_search_scope = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.search_scope");
    private static final Message T_full_text_search = SimpleSearch.message((String)"xmlui.ArtifactBrowser.SimpleSearch.full_text_search");
    private static final Message T_go = SimpleSearch.message((String)"xmlui.general.go");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException, SQLException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (dso instanceof Collection || dso instanceof Community) {
            HandleUtil.buildHandleTrail(dso, pageMeta, this.contextPath);
        }
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String queryString = this.getQuery();
        Division search = body.addDivision("search", "primary");
        search.setHead(T_head);
        Division query = search.addInteractiveDivision("general-query", "search", "get", "secondary search");
        List queryList = query.addList("search-query", "form");
        if (this.variableScope()) {
            Select scope = queryList.addItem().addSelect("scope");
            scope.setLabel(T_search_scope);
            this.buildScopeList(scope);
        }
        Text text = queryList.addItem().addText("query");
        text.setLabel(T_full_text_search);
        text.setValue(queryString);
        this.buildSearchControls(query);
        query.addPara(null, "button-list").addButton("submit").setValue(T_go);
        this.buildSearchResultsDivision(search);
    }

    @Override
    protected String getQuery() throws UIException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String query = SimpleSearch.URLDecode(request.getParameter("query"));
        if (query == null) {
            return "";
        }
        return query;
    }

    @Override
    protected String generateURL(Map<String, String> parameters) throws UIException {
        String query = this.getQuery();
        if (!"".equals(query)) {
            parameters.put("query", SimpleSearch.URLEncode(query));
        }
        if (parameters.get("page") == null) {
            parameters.put("page", String.valueOf(this.getParameterPage()));
        }
        if (parameters.get("rpp") == null) {
            parameters.put("rpp", String.valueOf(this.getParameterRpp()));
        }
        if (parameters.get("sort_by") == null) {
            parameters.put("sort_by", String.valueOf(this.getParameterSortBy()));
        }
        if (parameters.get("order") == null) {
            parameters.put("order", this.getParameterOrder());
        }
        if (parameters.get("etal") == null) {
            parameters.put("etal", String.valueOf(this.getParameterEtAl()));
        }
        return AbstractSearch.generateURL("search", parameters);
    }
}

