/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.core.Context;

public class DeleteBitstreamsConfirm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = DeleteBitstreamsConfirm.message((String)"xmlui.general.dspace_home");
    private static final Message T_item_trail = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_title = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.DeleteBitstreamConfirm.title");
    private static final Message T_trail = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.DeleteBitstreamConfirm.trail");
    private static final Message T_head1 = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.DeleteBitstreamConfirm.head1");
    private static final Message T_para1 = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.DeleteBitstreamConfirm.para1");
    private static final Message T_column1 = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.DeleteBitstreamConfirm.column1");
    private static final Message T_column2 = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.DeleteBitstreamConfirm.column2");
    private static final Message T_column3 = DeleteBitstreamsConfirm.message((String)"xmlui.administrative.item.DeleteBitstreamConfirm.column3");
    private static final Message T_submit_delete = DeleteBitstreamsConfirm.message((String)"xmlui.general.delete");
    private static final Message T_submit_cancel = DeleteBitstreamsConfirm.message((String)"xmlui.general.cancel");

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        String idsString = this.parameters.getParameter("bitstreamIDs", null);
        ArrayList<Bitstream> bitstreams = new ArrayList<Bitstream>();
        for (String id : idsString.split(",")) {
            String[] parts = id.split("/");
            if (parts.length != 2) {
                throw new UIException("Unable to parse id into bundle and bitstream id: " + id);
            }
            int bitstreamID = Integer.valueOf(parts[1]);
            Bitstream bitstream = Bitstream.find((Context)this.context, (int)bitstreamID);
            bitstreams.add(bitstream);
        }
        Division deleted = body.addInteractiveDivision("bitstreams-confirm-delete", this.contextPath + "/admin/item", "post", "primary administrative item");
        deleted.setHead(T_head1);
        deleted.addPara(T_para1);
        Table table = deleted.addTable("bitstreams-confirm-delete", bitstreams.size() + 1, 1);
        Row header = table.addRow("header");
        header.addCellContent(T_column1);
        header.addCellContent(T_column2);
        header.addCellContent(T_column3);
        for (Bitstream bitstream : bitstreams) {
            String format = null;
            BitstreamFormat bitstreamFormat = bitstream.getFormat();
            if (bitstreamFormat != null) {
                format = bitstreamFormat.getShortDescription();
            }
            Row row = table.addRow();
            row.addCell().addContent(bitstream.getName());
            row.addCell().addContent(bitstream.getDescription());
            row.addCell().addContent(format);
        }
        Para buttons = deleted.addPara();
        buttons.addButton("submit_confirm").setValue(T_submit_delete);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        deleted.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

