/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.utils.servicemanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.dspace.kernel.ServiceManager;
import org.dspace.kernel.mixins.OrderedService;
import org.dspace.utils.servicemanager.NotProvider;
import org.dspace.utils.servicemanager.OrderedServiceComparator;
import org.dspace.utils.servicemanager.ProviderHolder;
import org.dspace.utils.servicemanager.ProviderStackComparator;

public final class ProviderStack<T> {
    protected final List<ProviderHolder<T>> providers = Collections.synchronizedList(new ArrayList());

    public ProviderStack() {
    }

    public ProviderStack(ServiceManager serviceManager, Class<T> providerType) {
        List<T> foundProviders = serviceManager.getServicesByType(providerType);
        Iterator<T> iterator = foundProviders.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!(t instanceof NotProvider)) continue;
            iterator.remove();
        }
        Collections.sort(foundProviders, new OrderedServiceComparator());
        for (T t : foundProviders) {
            this.providers.add(new ProviderHolder<T>(t));
        }
    }

    public ProviderStack(T[] currentProviders) {
        Object t2;
        int i;
        ArrayList<T> tList = new ArrayList<T>();
        for (i = 0; i < currentProviders.length; ++i) {
            t2 = currentProviders[i];
            if (t2 instanceof NotProvider || !(t2 instanceof OrderedService)) continue;
            tList.add(t2);
        }
        Collections.sort(tList, new OrderedServiceComparator());
        for (i = 0; i < currentProviders.length; ++i) {
            t2 = currentProviders[i];
            if (t2 instanceof OrderedService || t2 instanceof NotProvider) continue;
            tList.add(t2);
        }
        for (Object t2 : tList) {
            this.providers.add(new ProviderHolder<T>(t2));
        }
        tList.clear();
    }

    public int addProvider(T provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider to add cannot be null");
        }
        int position = 0;
        this.refresh();
        int providerOrder = 0;
        if (provider instanceof NotProvider) {
            throw new IllegalArgumentException("Cannot place anything that implements NotProvider into the provider stack, failure for: " + provider);
        }
        if (provider instanceof OrderedService) {
            providerOrder = ((OrderedService)provider).getOrder();
        }
        this.providers.add(new ProviderHolder<T>(provider));
        if (providerOrder > 0) {
            Collections.sort(this.providers, new ProviderStackComparator());
        }
        return position;
    }

    public boolean removeProvider(int position) {
        boolean removed = false;
        try {
            this.providers.remove(position);
            removed = true;
        }
        catch (IndexOutOfBoundsException e) {
            removed = false;
        }
        this.refresh();
        return removed;
    }

    public boolean removeProvider(T provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider to remove cannot be null");
        }
        boolean removed = false;
        this.refresh();
        Iterator<ProviderHolder<T>> iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ProviderHolder<T> holder = iterator.next();
            T p = holder.getProvider();
            if (p == null) {
                iterator.remove();
                continue;
            }
            if (!p.equals(provider)) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    public List<T> getProviders() {
        List<T> l = this.refresh();
        return Collections.unmodifiableList(l);
    }

    public List<ProviderHolder<T>> getProviderHolders() {
        return Collections.unmodifiableList(this.providers);
    }

    public Iterator<T> getIterator() {
        return new Iterator<T>(){
            protected ListIterator<ProviderHolder<T>> it = null;

            @Override
            public synchronized boolean hasNext() {
                if (this.it == null) {
                    this.it = ProviderStack.this.providers.listIterator();
                }
                return this.it.hasNext();
            }

            @Override
            public synchronized T next() {
                ProviderHolder holder;
                if (this.it == null) {
                    this.it = ProviderStack.this.providers.listIterator();
                }
                Object t = null;
                while (this.it.hasNext() && (t = (Object)(holder = this.it.next()).getProvider()) == null) {
                }
                if (t == null) {
                    throw new NoSuchElementException("No more providers remain with valid weak references");
                }
                return t;
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public T getProvider(int position) {
        T provider = null;
        ProviderHolder<T> holder = this.getProviderHolder(position);
        if (holder != null) {
            provider = holder.getProvider();
        }
        return provider;
    }

    public ProviderHolder<T> getProviderHolder(int position) {
        ProviderHolder<T> holder;
        this.refresh();
        try {
            holder = this.providers.get(position);
        }
        catch (IndexOutOfBoundsException e) {
            holder = null;
        }
        return holder;
    }

    public int size() {
        this.refresh();
        return this.providers.size();
    }

    public void clear() {
        this.providers.clear();
    }

    protected List<T> refresh() {
        ArrayList<T> l = new ArrayList<T>();
        Iterator<ProviderHolder<T>> iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ProviderHolder<T> holder = iterator.next();
            T provider = holder.getProvider();
            if (provider == null) {
                iterator.remove();
                continue;
            }
            l.add(provider);
        }
        return l;
    }
}

