/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.spring;

import org.dspace.servicemanager.ServiceManagerSystem;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public final class DSpaceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private ServiceManagerSystem serviceManager;
    private DSpaceConfigurationService configurationService;
    private boolean testMode = false;

    public DSpaceBeanFactoryPostProcessor(ServiceManagerSystem serviceManager, DSpaceConfigurationService configurationService, boolean testMode) {
        if (configurationService == null) {
            throw new IllegalArgumentException("Configuration service cannot be null");
        }
        this.serviceManager = serviceManager;
        this.configurationService = configurationService;
        this.testMode = testMode;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerSingleton(ConfigurationService.class.getName(), (Object)this.configurationService);
        beanFactory.registerSingleton(ServiceManagerSystem.class.getName(), (Object)this.serviceManager);
    }
}

