/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.utils;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class CallStackUtils {
    private CallStackUtils() {
    }

    public static void logCaller(Logger log, Level level) {
        if (log.isEnabled(level)) {
            StackWalker stack = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            StackWalker.StackFrame caller = stack.walk(stream -> (StackWalker.StackFrame)stream.skip(2L).findFirst().get());
            String callerClassName = caller.getDeclaringClass().getCanonicalName();
            String callerMethodName = caller.getMethodName();
            int callerLine = caller.getLineNumber();
            log.log(level, "Called from {}.{} line {}.", (Object)callerClassName, (Object)callerMethodName, (Object)callerLine);
        }
    }
}

