/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.spring;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ResourceFinder {
    private static final Logger log = LogManager.getLogger();
    public static final String relativePath = "dspace/";
    public static final String environmentPathVariable = "dspace.dir";

    private ResourceFinder() {
    }

    private static List<Resource> makeResources(List<String> paths) {
        ArrayList<Resource> rs = new ArrayList<Resource>();
        if (paths != null && !paths.isEmpty()) {
            for (String path : paths) {
                try {
                    Resource r = ResourceFinder.makeResource(path);
                    rs.add(r);
                }
                catch (IllegalArgumentException e) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = e::getMessage;
                    log.error("{}, continuing...", supplierArray);
                }
            }
        }
        return rs;
    }

    private static Resource makeResource(String path) {
        Resource r;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!(r = ResourceFinder.findResource(path)).exists()) {
            int fileStart = path.lastIndexOf(47) + 1;
            String fileName = path.substring(fileStart);
            r = ResourceFinder.findResource(fileName);
        }
        if (!r.exists()) {
            throw new IllegalArgumentException("Could not find this resource (" + path + ") in any of the checked locations");
        }
        return r;
    }

    private static Resource findResource(String path) {
        ClassLoader cl;
        String relPath;
        String envPath = ResourceFinder.getEnvironmentPath() + path;
        FileSystemResource r = new FileSystemResource(envPath);
        if (!(r.exists() || (r = new FileSystemResource(relPath = ResourceFinder.getRelativePath() + path)).exists() || (r = new ClassPathResource(path, cl = ResourceFinder.class.getClassLoader())).exists())) {
            cl = Thread.currentThread().getContextClassLoader();
            r = new ClassPathResource(path, cl);
        }
        return r;
    }

    public static Resource[] getResources(List<String> paths) {
        return ResourceFinder.makeResources(paths).toArray(new Resource[paths.size()]);
    }

    public static File[] getFiles(List<String> paths) {
        List<Resource> rs = ResourceFinder.makeResources(paths);
        File[] files = new File[rs.size()];
        for (int i = 0; i < rs.size(); ++i) {
            Resource r = rs.get(i);
            try {
                files[i] = r.getFile();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get file for: " + r.getFilename(), e);
            }
        }
        return files;
    }

    public static InputStream[] getInputStreams(List<String> paths) {
        List<Resource> rs = ResourceFinder.makeResources(paths);
        InputStream[] streams = new InputStream[rs.size()];
        for (int i = 0; i < rs.size(); ++i) {
            Resource r = rs.get(i);
            try {
                streams[i] = r.getInputStream();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get inputstream for: " + r.getFilename(), e);
            }
        }
        return streams;
    }

    public static Resource getResource(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Invalid null path");
        }
        return ResourceFinder.makeResource(path);
    }

    public static Resource getResourceFromPaths(String[] paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Invalid null paths");
        }
        Resource r = null;
        for (String path : paths) {
            try {
                r = ResourceFinder.makeResource(path);
                break;
            }
            catch (IllegalArgumentException e) {
            }
        }
        if (r == null) {
            throw new IllegalArgumentException("Could not find any resource from paths (" + Arrays.toString(paths) + ") in any of the checked locations");
        }
        return r;
    }

    public static File getFile(String path) {
        Resource r = ResourceFinder.getResource(path);
        File f = null;
        try {
            f = r.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get file for: " + r.getFilename(), e);
        }
        return f;
    }

    public static InputStream getInputStream(String path) {
        Resource r = ResourceFinder.getResource(path);
        InputStream is = null;
        try {
            is = r.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get inputstream for: " + r.getFilename(), e);
        }
        return is;
    }

    protected static String getRelativePath() {
        Object absPath;
        File currentPath = new File("");
        File f = new File(currentPath, relativePath);
        if (!(f.exists() && f.isDirectory() || (f = new File(currentPath, "dspace")).exists() && f.isDirectory())) {
            f = currentPath;
        }
        if (!((String)(absPath = f.getAbsolutePath())).endsWith("" + File.separatorChar)) {
            absPath = (String)absPath + File.separatorChar;
        }
        return absPath;
    }

    protected static String getEnvironmentPath() {
        Object envPath = System.getenv(environmentPathVariable);
        if (envPath == null && (envPath = System.getProperty(environmentPathVariable)) == null) {
            String container = ResourceFinder.getContainerHome();
            if (container == null) {
                container = "";
            }
            envPath = container + File.separatorChar + "dspace" + File.separatorChar;
        }
        return envPath;
    }

    public static String getContainerHome() {
        String catalina = System.getProperty("catalina.base");
        if (catalina == null) {
            catalina = System.getProperty("catalina.home");
        }
        return catalina;
    }
}

