/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step.validation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.step.validation.AbstractValidation;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.Bitstream;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.service.BitstreamService;
import org.springframework.beans.factory.annotation.Autowired;

public class LicenseValidation
extends AbstractValidation {
    private static final String ERROR_VALIDATION_LICENSEREQUIRED = "error.validation.license.notgranted";
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private BitstreamService bitstreamService;

    public List<ErrorRest> validate(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws DCInputsReaderException, SQLException {
        ArrayList<ErrorRest> errors = new ArrayList<ErrorRest>();
        Bitstream bitstream = this.bitstreamService.getBitstreamByName(obj.getItem(), "LICENSE", "license.txt");
        if (bitstream == null) {
            this.addError(errors, ERROR_VALIDATION_LICENSEREQUIRED, "/sections/" + config.getId());
        }
        return errors;
    }

    public BitstreamService getBitstreamService() {
        return this.bitstreamService;
    }

    public void setBitstreamService(BitstreamService bitstreamService) {
        this.bitstreamService = bitstreamService;
    }
}

