/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.submit.factory.impl.RemovePatchOperation;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public abstract class MetadataValueRemovePatchOperation<DSO extends DSpaceObject>
extends RemovePatchOperation<MetadataValueRest> {
    private static final Logger log = LogManager.getLogger();

    @Override
    protected Class<MetadataValueRest[]> getArrayClassForEvaluation() {
        return MetadataValueRest[].class;
    }

    @Override
    protected Class<MetadataValueRest> getClassForEvaluation() {
        return MetadataValueRest.class;
    }

    protected void deleteValue(Context context, DSO source, String target, int index) throws SQLException {
        String[] metadata = Utils.tokenize((String)target);
        List mm = this.getDSpaceObjectService().getMetadata(source, metadata[0], metadata[1], metadata[2], "*");
        if (index != -1) {
            if (index < mm.size()) {
                this.getDSpaceObjectService().removeMetadataValues(context, source, Arrays.asList((MetadataValue)mm.get(index)));
            } else {
                log.warn("value of index ({}) is out of range of the metadata value list of size {} (target: {})", (Object)index, (Object)mm.size(), (Object)target);
            }
        } else {
            this.getDSpaceObjectService().clearMetadata(context, source, metadata[0], metadata[1], metadata[2], "*");
        }
    }

    protected abstract DSpaceObjectService<DSO> getDSpaceObjectService();
}

