/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.content.QAEvent;
import org.dspace.core.Context;
import org.dspace.qaevent.service.QAEventActionService;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QAEventStatusReplaceOperation
extends PatchOperation<QAEvent> {
    @Autowired
    private RequestService requestService;
    @Autowired
    private QAEventActionService qaEventActionService;

    @Override
    public QAEvent perform(Context context, QAEvent qaevent, Operation operation) throws SQLException {
        String value = (String)operation.getValue();
        if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"accepted")) {
            this.qaEventActionService.accept(context, qaevent);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"rejected")) {
            this.qaEventActionService.reject(context, qaevent);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"discarded")) {
            this.qaEventActionService.discard(context, qaevent);
        } else {
            throw new IllegalArgumentException("The received operation is not valid: " + operation.getPath() + " - " + value);
        }
        qaevent.setStatus(value.toUpperCase());
        this.requestService.getCurrentRequest().setAttribute("patchedNotificationEvent", (Object)qaevent);
        return qaevent;
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return StringUtils.equals((CharSequence)operation.getOp(), (CharSequence)"replace") && objectToMatch instanceof QAEvent && StringUtils.containsAny((CharSequence)operation.getValue().toString().toLowerCase(), (CharSequence[])new CharSequence[]{"accepted", "discarded", "rejected"});
    }
}

