/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link.search;

import java.util.LinkedList;
import org.dspace.app.rest.link.search.DiscoveryRestHalLinkFactory;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.app.rest.model.SearchFacetValueRest;
import org.dspace.app.rest.model.hateoas.SearchFacetValueResource;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class SearchFacetValueHalLinkFactory
extends DiscoveryRestHalLinkFactory<SearchFacetValueResource> {
    @Override
    protected void addLinks(SearchFacetValueResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        if (halResource.getSearchData() != null && halResource.getFacetData() != null && halResource.getValueData() != null) {
            UriComponentsBuilder builder = this.buildSearchBaseLink(halResource.getSearchData());
            this.addFilterForFacetValue(builder, halResource.getFacetData(), halResource.getValueData());
            list.add(this.buildLink("search", builder.build().encode().toUriString()));
        }
    }

    @Override
    protected Class<SearchFacetValueResource> getResourceClass() {
        return SearchFacetValueResource.class;
    }

    private void addFilterForFacetValue(UriComponentsBuilder baseLink, SearchFacetEntryRest facetData, SearchFacetValueRest valueData) {
        baseLink.queryParam("f." + facetData.getName(), new Object[]{valueData.getFilterValue() + "," + valueData.getFilterType()});
    }
}

