/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.hateoas.ItemResource;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.qaevent.service.QAEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integration/qualityassuranceevents/{id:^(?!^\\d+$)(?!^[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}$)[\\w+\\-\\.:!]+$+}/related"})
public class QAEventRelatedRestController {
    @Autowired
    protected Utils utils;
    @Autowired
    private ConverterService converterService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private QAEventService qaEventService;

    @PostMapping
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ResponseEntity<RepresentationModel<?>> addRelatedItem(@PathVariable(name="id") String qaeventId, @RequestParam(name="item") UUID relatedItemUUID) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainCurrentRequestContext();
        QAEvent qaevent = this.qaEventService.findEventByEventId(qaeventId);
        if (qaevent == null) {
            throw new ResourceNotFoundException("No such qa event: " + qaeventId);
        }
        if (!this.qaEventService.isRelatedItemSupported(qaevent)) {
            throw new UnprocessableEntityException("The given event does not supports a related item");
        }
        if (qaevent.getRelated() != null) {
            throw new UnprocessableEntityException("The given event already has a related item");
        }
        Item relatedItem = (Item)this.itemService.find(context, relatedItemUUID);
        if (relatedItem == null) {
            throw new UnprocessableEntityException("The proposed related item was not found");
        }
        qaevent.setRelated(relatedItemUUID.toString());
        this.qaEventService.store(context, qaevent);
        ItemRest relatedItemRest = (ItemRest)this.converterService.toRest(relatedItem, this.utils.obtainProjection());
        ItemResource itemResource = (ItemResource)((Object)this.converterService.toResource(relatedItemRest));
        context.complete();
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), (RepresentationModel)itemResource);
    }

    @DeleteMapping
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ResponseEntity<RepresentationModel<?>> removeRelatedItem(@PathVariable(name="id") String qaeventId) throws SQLException, AuthorizeException, IOException {
        Context context = ContextUtil.obtainCurrentRequestContext();
        QAEvent qaevent = this.qaEventService.findEventByEventId(qaeventId);
        if (qaevent == null) {
            throw new ResourceNotFoundException("No such qa event: " + qaeventId);
        }
        if (!this.qaEventService.isRelatedItemSupported(qaevent)) {
            throw new UnprocessableEntityException("The given event does not supports a related item");
        }
        if (qaevent.getRelated() != null) {
            qaevent.setRelated(null);
            this.qaEventService.store(context, qaevent);
            context.complete();
        }
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }
}

