/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.TemplateItemRest;
import org.dspace.app.rest.model.hateoas.TemplateItemResource;
import org.dspace.app.rest.repository.CollectionRestRepository;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/core/collections/{uuid:[0-9a-fxA-FX]{8}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{4}-[0-9a-fxA-FX]{12}}/itemtemplate"})
public class CollectionItemTemplateController {
    @Autowired
    private Utils utils;
    @Autowired
    private CollectionRestRepository collectionRestRepository;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private ConverterService converter;
    @Autowired
    private ObjectMapper mapper;

    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'WRITE')")
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<RepresentationModel<?>> createTemplateItem(HttpServletRequest request, @PathVariable UUID uuid, @RequestBody(required=false) JsonNode itemBody) throws SQLException, AuthorizeException {
        TemplateItemRest inputTemplateItemRest;
        if (itemBody == null) {
            throw new BadRequestException("The new item should be included as json in the body of this request");
        }
        Context context = ContextUtil.obtainContext(request);
        Collection collection = this.getCollection(context, uuid);
        try {
            inputTemplateItemRest = (TemplateItemRest)this.mapper.readValue(itemBody.toString(), TemplateItemRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body", e1);
        }
        TemplateItemRest templateItem = this.collectionRestRepository.createTemplateItem(context, collection, inputTemplateItemRest);
        context.commit();
        return ControllerUtils.toResponseEntity((HttpStatus)HttpStatus.CREATED, (HttpHeaders)new HttpHeaders(), this.converter.toResource(templateItem));
    }

    @PreAuthorize(value="hasPermission(#uuid, 'COLLECTION', 'READ')")
    @RequestMapping(method={RequestMethod.GET})
    public TemplateItemResource getTemplateItem(HttpServletRequest request, @PathVariable UUID uuid) throws SQLException {
        Context context = ContextUtil.obtainContext(request);
        Collection collection = this.getCollection(context, uuid);
        TemplateItemRest templateItem = this.collectionRestRepository.getTemplateItem(collection);
        return (TemplateItemResource)((Object)this.converter.toResource(templateItem));
    }

    private Collection getCollection(Context context, UUID uuid) throws SQLException {
        Collection collection = (Collection)this.collectionService.find(context, uuid);
        if (collection == null) {
            throw new ResourceNotFoundException("The given uuid did not resolve to a collection on the server: " + uuid);
        }
        return collection;
    }
}

