/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security.jwt;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.util.DateUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.app.rest.security.jwt.EPersonClaimProvider;
import org.dspace.app.rest.security.jwt.JWTClaimProvider;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;

public abstract class JWTTokenHandler {
    private static final int MAX_CLOCK_SKEW_SECONDS = 60;
    private static final String AUTHORIZATION_TOKEN_PARAMETER = "authentication-token";
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private List<JWTClaimProvider> jwtClaimProviders;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EPersonClaimProvider ePersonClaimProvider;
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private ClientInfoService clientInfoService;
    private String generatedJwtKey;
    private String generatedEncryptionKey;

    protected abstract String getTokenSecretConfigurationKey();

    protected abstract String getEncryptionSecretConfigurationKey();

    protected abstract String getTokenExpirationConfigurationKey();

    protected abstract String getEncryptionEnabledConfigurationKey();

    protected abstract String getCompressionEnabledConfigurationKey();

    public EPerson parseEPersonFromToken(String token, HttpServletRequest request, Context context) throws JOSEException, ParseException, SQLException {
        EPerson ePerson;
        JWTClaimsSet jwtClaimsSet;
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        SignedJWT signedJWT = this.getSignedJWT(token);
        if (this.isValidToken(request, signedJWT, jwtClaimsSet = signedJWT.getJWTClaimsSet(), ePerson = this.getEPerson(context, jwtClaimsSet))) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((EPerson)ePerson).getEmail();
            log.debug("Received valid token for username: {}", supplierArray);
            for (JWTClaimProvider jwtClaimProvider : this.jwtClaimProviders) {
                jwtClaimProvider.parseClaim(context, request, jwtClaimsSet);
            }
            return ePerson;
        }
        log.warn("{} tried to use an expired or non-valid token", (Object)this.getIpAddress(request));
        return null;
    }

    public String createTokenForEPerson(Context context, HttpServletRequest request, Instant previousLoginDate) throws JOSEException, SQLException {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(AUTHORIZATION_TOKEN_PARAMETER))) {
            throw new AccessDeniedException("Short lived tokens can't be used to generate other tokens");
        }
        EPerson ePerson = this.updateSessionSalt(context, previousLoginDate);
        JWTClaimsSet claimsSet = this.buildJwtClaimsSet(context, request);
        SignedJWT signedJWT = this.createSignedJWT(request, ePerson, claimsSet);
        String token = this.isEncryptionEnabled() ? this.encryptJWT(signedJWT).serialize() : signedJWT.serialize();
        return token;
    }

    public void invalidateToken(String token, HttpServletRequest request, Context context) throws Exception {
        EPerson ePerson;
        if (StringUtils.isNotBlank((CharSequence)token) && (ePerson = this.parseEPersonFromToken(token, request, context)) != null) {
            ePerson.setSessionSalt("");
        }
    }

    public String getJwtKey() {
        String secret = this.configurationService.getProperty(this.getTokenSecretConfigurationKey());
        if (StringUtils.isBlank((CharSequence)secret)) {
            if (StringUtils.isBlank((CharSequence)this.generatedJwtKey)) {
                this.generatedJwtKey = this.generateRandomKey();
            }
            secret = this.generatedJwtKey;
        }
        return secret;
    }

    public long getExpirationPeriod() {
        return this.configurationService.getLongProperty(this.getTokenExpirationConfigurationKey(), 1800000L);
    }

    public boolean isEncryptionEnabled() {
        return this.configurationService.getBooleanProperty(this.getEncryptionEnabledConfigurationKey(), false);
    }

    public boolean getCompressionEnabled() {
        return this.configurationService.getBooleanProperty(this.getCompressionEnabledConfigurationKey(), false);
    }

    public byte[] getEncryptionKey() {
        String secretString = this.configurationService.getProperty(this.getEncryptionSecretConfigurationKey());
        if (StringUtils.isBlank((CharSequence)secretString)) {
            if (StringUtils.isBlank((CharSequence)this.generatedEncryptionKey)) {
                this.generatedEncryptionKey = this.generateRandomKey();
            }
            secretString = this.generatedEncryptionKey;
        }
        return secretString.getBytes();
    }

    private JWEObject encryptJWT(SignedJWT signedJWT) throws JOSEException {
        JWEObject jweObject = new JWEObject(this.compression(new JWEHeader.Builder(JWEAlgorithm.DIR, EncryptionMethod.A128GCM).contentType("JWT")).build(), new Payload(signedJWT));
        jweObject.encrypt((JWEEncrypter)new DirectEncrypter(this.getEncryptionKey()));
        return jweObject;
    }

    protected boolean isValidToken(HttpServletRequest request, SignedJWT signedJWT, JWTClaimsSet jwtClaimsSet, EPerson ePerson) throws JOSEException {
        if (ePerson == null || StringUtils.isBlank((CharSequence)ePerson.getSessionSalt())) {
            return false;
        }
        MACVerifier verifier = new MACVerifier(this.buildSigningKey(ePerson));
        Date expirationTime = jwtClaimsSet.getExpirationTime();
        return signedJWT.verify((JWSVerifier)verifier) && expirationTime != null && DateUtils.isAfter((Date)expirationTime, (Date)Date.from(Instant.now()), (long)60L);
    }

    private SignedJWT getSignedJWT(String token) throws ParseException, JOSEException {
        SignedJWT signedJWT;
        if (this.isEncryptionEnabled()) {
            JWEObject jweObject = JWEObject.parse((String)token);
            jweObject.decrypt((JWEDecrypter)new DirectDecrypter(this.getEncryptionKey()));
            signedJWT = jweObject.getPayload().toSignedJWT();
        } else {
            signedJWT = SignedJWT.parse((String)token);
        }
        return signedJWT;
    }

    private EPerson getEPerson(Context context, JWTClaimsSet jwtClaimsSet) throws SQLException {
        return this.ePersonClaimProvider.getEPerson(context, jwtClaimsSet);
    }

    private SignedJWT createSignedJWT(HttpServletRequest request, EPerson ePerson, JWTClaimsSet claimsSet) throws JOSEException {
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claimsSet);
        MACSigner signer = new MACSigner(this.buildSigningKey(ePerson));
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }

    private JWTClaimsSet buildJwtClaimsSet(Context context, HttpServletRequest request) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        for (JWTClaimProvider jwtClaimProvider : this.jwtClaimProviders) {
            builder = builder.claim(jwtClaimProvider.getKey(), jwtClaimProvider.getValue(context, request));
        }
        return builder.expirationTime(Date.from(Instant.ofEpochMilli(Instant.now().toEpochMilli() + this.getExpirationPeriod()))).build();
    }

    private JWEHeader.Builder compression(JWEHeader.Builder builder) {
        if (this.getCompressionEnabled()) {
            return builder.compressionAlgorithm(CompressionAlgorithm.DEF);
        }
        return builder;
    }

    protected String buildSigningKey(EPerson ePerson) {
        return this.getJwtKey() + ePerson.getSessionSalt();
    }

    private String getIpAddress(HttpServletRequest request) {
        return this.clientInfoService.getClientIp(request);
    }

    protected EPerson updateSessionSalt(Context context, Instant previousLoginDate) throws SQLException {
        EPerson ePerson;
        try {
            ePerson = context.getCurrentUser();
            if (StringUtils.isBlank((CharSequence)ePerson.getSessionSalt()) || previousLoginDate == null || ePerson.getLastActive().toEpochMilli() - previousLoginDate.toEpochMilli() > this.getExpirationPeriod()) {
                log.debug("Regenerating auth token as session salt was either empty or expired..");
                ePerson.setSessionSalt(this.generateRandomKey());
                this.ePersonService.update(context, (DSpaceObject)ePerson);
            }
        }
        catch (AuthorizeException e) {
            ePerson = null;
        }
        return ePerson;
    }

    private String generateRandomKey() {
        BytesKeyGenerator bytesKeyGenerator = KeyGenerators.secureRandom((int)24);
        byte[] secretKey = bytesKeyGenerator.generateKey();
        return Base64.encodeBase64String((byte[])secretKey);
    }
}

