/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.AccessConditionDTO;
import org.dspace.app.rest.model.patch.LateObjectEvaluator;
import org.dspace.app.rest.submit.factory.impl.AccessConditionResourcePolicyUtils;
import org.dspace.app.rest.submit.factory.impl.AddPatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.submit.model.AccessConditionConfiguration;
import org.dspace.submit.model.AccessConditionConfigurationService;
import org.dspace.util.TimeHelpers;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessConditionAddPatchOperation
extends AddPatchOperation<AccessConditionDTO> {
    @Autowired
    private ResourcePolicyService resourcePolicyService;
    @Autowired
    private AccessConditionConfigurationService accessConditionConfigurationService;

    @Override
    void add(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String stepId = (String)currentRequest.getAttribute("accessConditionSectionId");
        AccessConditionConfiguration configuration = this.accessConditionConfigurationService.getAccessConfigurationById(stepId);
        Item item = source.getItem();
        String[] absolutePath = this.getAbsolutePath(path).split("/");
        List<AccessConditionDTO> accessConditions = this.parseAccessConditions(path, value, absolutePath);
        for (AccessConditionDTO condition : accessConditions) {
            Date date = condition.getStartDate();
            if (null != date) {
                condition.setStartDate(TimeHelpers.toMidnightUTC((Date)date));
            }
            if (null == (date = condition.getEndDate())) continue;
            condition.setEndDate(TimeHelpers.toMidnightUTC((Date)date));
        }
        this.verifyAccessConditions(context, configuration, accessConditions);
        if (absolutePath.length == 1) {
            this.resourcePolicyService.removePolicies(context, (DSpaceObject)item, ResourcePolicy.TYPE_CUSTOM);
        }
        AccessConditionResourcePolicyUtils.findApplyResourcePolicy(context, configuration.getOptions(), (DSpaceObject)item, accessConditions);
    }

    private List<AccessConditionDTO> parseAccessConditions(String path, Object value, String[] split) {
        ArrayList<AccessConditionDTO> accessConditions = new ArrayList();
        if (split.length == 1) {
            accessConditions = this.evaluateArrayObject((LateObjectEvaluator)value);
        } else if (split.length == 2) {
            accessConditions.add((AccessConditionDTO)this.evaluateSingleObject((LateObjectEvaluator)value));
        } else {
            throw new UnprocessableEntityException("The patch operation for path:" + path + " is not supported!");
        }
        return accessConditions;
    }

    private void verifyAccessConditions(Context context, AccessConditionConfiguration configuration, List<AccessConditionDTO> accessConditions) throws SQLException, AuthorizeException, ParseException {
        for (AccessConditionDTO dto : accessConditions) {
            AccessConditionResourcePolicyUtils.canApplyResourcePolicy(context, configuration.getOptions(), dto.getName(), dto.getStartDate(), dto.getEndDate());
        }
    }

    @Override
    protected Class<AccessConditionDTO[]> getArrayClassForEvaluation() {
        return AccessConditionDTO[].class;
    }

    @Override
    protected Class<AccessConditionDTO> getClassForEvaluation() {
        return AccessConditionDTO.class;
    }
}

