/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.Filter;
import org.dspace.app.rest.exception.DSpaceAccessDeniedHandler;
import org.dspace.app.rest.security.AnonymousAdditionalAuthorizationFilter;
import org.dspace.app.rest.security.CustomLogoutHandler;
import org.dspace.app.rest.security.DSpace401AuthenticationEntryPoint;
import org.dspace.app.rest.security.DSpaceCsrfAuthenticationStrategy;
import org.dspace.app.rest.security.DSpaceCsrfTokenRepository;
import org.dspace.app.rest.security.EPersonRestAuthenticationProvider;
import org.dspace.app.rest.security.OidcLoginFilter;
import org.dspace.app.rest.security.OrcidLoginFilter;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.security.ShibbolethLoginFilter;
import org.dspace.app.rest.security.StatelessAuthenticationFilter;
import org.dspace.app.rest.security.StatelessLoginFilter;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
@Configuration
@EnableConfigurationProperties(value={SecurityProperties.class})
public class WebSecurityConfiguration {
    public static final String ADMIN_GRANT = "ADMIN";
    public static final String AUTHENTICATED_GRANT = "AUTHENTICATED";
    public static final String ANONYMOUS_GRANT = "ANONYMOUS";
    @Autowired
    private EPersonRestAuthenticationProvider ePersonRestAuthenticationProvider;
    @Autowired
    private RestAuthenticationService restAuthenticationService;
    @Autowired
    private RequestService requestService;
    @Autowired
    private CustomLogoutHandler customLogoutHandler;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private DSpaceAccessDeniedHandler accessDeniedHandler;
    @Value(value="${management.endpoints.web.base-path:/actuator}")
    private String actuatorBasePath;

    @Bean
    public AuthenticationManager authenticationManager() {
        ProviderManager manager = new ProviderManager(new AuthenticationProvider[]{this.ePersonRestAuthenticationProvider});
        return manager;
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        AuthenticationManager authenticationManager = this.authenticationManager();
        CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
        requestHandler.setCsrfRequestAttributeName(null);
        http.securityMatcher(new String[]{"/api/**", "/iiif/**", this.actuatorBasePath + "/**", "/signposting/**"}).authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(this.actuatorBasePath + "/info", HttpMethod.GET.name())})).hasAnyAuthority(new String[]{ADMIN_GRANT}).anyRequest()).permitAll()).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).anonymous(anonymous -> anonymous.authorities(new String[]{ANONYMOUS_GRANT})).servletApi(Customizer.withDefaults()).cors(Customizer.withDefaults()).csrf(csrf -> csrf.csrfTokenRepository(this.csrfTokenRepository()).sessionAuthenticationStrategy((SessionAuthenticationStrategy)this.dSpaceCsrfAuthenticationStrategy()).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler)).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)new DSpace401AuthenticationEntryPoint(this.restAuthenticationService)).accessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler)).logout(logout -> logout.addLogoutHandler((LogoutHandler)this.customLogoutHandler).logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/api/authn/logout", HttpMethod.POST.name())).logoutSuccessHandler((LogoutSuccessHandler)new HttpStatusReturningLogoutSuccessHandler(HttpStatus.NO_CONTENT))).addFilterBefore((Filter)new AnonymousAdditionalAuthorizationFilter(authenticationManager, this.authenticationService), StatelessAuthenticationFilter.class).addFilterBefore((Filter)new StatelessLoginFilter("/api/authn/login", HttpMethod.POST.name(), authenticationManager, this.restAuthenticationService), LogoutFilter.class).addFilterBefore((Filter)new ShibbolethLoginFilter("/api/authn/shibboleth", HttpMethod.GET.name(), authenticationManager, this.restAuthenticationService), LogoutFilter.class).addFilterBefore((Filter)new OrcidLoginFilter("/api/authn/orcid", HttpMethod.GET.name(), authenticationManager, this.restAuthenticationService), LogoutFilter.class).addFilterBefore((Filter)new OidcLoginFilter("/api/authn/oidc", HttpMethod.GET.name(), authenticationManager, this.restAuthenticationService), LogoutFilter.class).addFilterBefore((Filter)new StatelessAuthenticationFilter(authenticationManager, this.restAuthenticationService, this.ePersonRestAuthenticationProvider, this.requestService), StatelessLoginFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Lazy
    @Bean
    public CsrfTokenRepository csrfTokenRepository() {
        return new DSpaceCsrfTokenRepository();
    }

    @Lazy
    @Bean
    public DSpaceCsrfAuthenticationStrategy dSpaceCsrfAuthenticationStrategy() {
        return new DSpaceCsrfAuthenticationStrategy(this.csrfTokenRepository());
    }
}

