/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceInboundPattern;
import org.dspace.app.ldn.service.NotifyServiceInboundPatternService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.ldn.NotifyServicePatchUtils;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceInboundPatternRemoveOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyServiceInboundPatternService inboundPatternService;
    @Autowired
    private NotifyServicePatchUtils notifyServicePatchUtils;
    private static final String OPERATION_PATH = "notifyServiceInboundPatterns[";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) {
        if (this.supports(notifyServiceEntity, operation)) {
            try {
                int index = this.notifyServicePatchUtils.extractIndexFromOperation(operation);
                List inboundPatterns = notifyServiceEntity.getInboundPatterns();
                if (index >= inboundPatterns.size()) {
                    throw new DSpaceBadRequestException("the provided index[" + index + "] is out of the rang");
                }
                this.inboundPatternService.delete(context, (NotifyServiceInboundPattern)inboundPatterns.get(index));
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return notifyServiceEntity;
        }
        throw new DSpaceBadRequestException("NotifyServiceInboundPatternRemoveOperation does not support this operation");
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        String path = operation.getPath().trim();
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("remove") && path.startsWith(OPERATION_PATH) && path.endsWith("]");
    }
}

