/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/authz/resourcepolicies/{id:\\d+}/group"})
public class ResourcePolicyGroupReplaceRestController {
    @Autowired
    private Utils utils;
    @Autowired
    private ResourcePolicyService resourcePolicyService;

    @PreAuthorize(value="hasPermission(#id, 'resourcepolicy', 'ADMIN')")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"text/uri-list"})
    public ResponseEntity<RepresentationModel<?>> replaceGroupOfResourcePolicy(@PathVariable Integer id, HttpServletResponse response, HttpServletRequest request) throws SQLException, AuthorizeException {
        Context context = ContextUtil.obtainContext(request);
        List<DSpaceObject> dsoList = this.utils.constructDSpaceObjectList(context, this.utils.getStringListFromRequest(request));
        if (dsoList.size() != 1 || dsoList.get(0).getType() != 6) {
            throw new UnprocessableEntityException("The Group doesn't exist or the data cannot be resolved to a Group");
        }
        ResourcePolicy resourcePolicy = this.resourcePolicyService.find(context, id.intValue());
        if (Objects.isNull(resourcePolicy)) {
            throw new ResourceNotFoundException("ResourcePolicy with id: " + id + " not found!");
        }
        if (Objects.isNull(resourcePolicy.getGroup())) {
            throw new UnprocessableEntityException("ResourcePolicy with id:" + id + "  doesn't link to a Group");
        }
        Group newGroup = (Group)dsoList.get(0);
        resourcePolicy.setGroup(newGroup);
        this.resourcePolicyService.update(context, resourcePolicy);
        context.commit();
        return ControllerUtils.toEmptyResponse((HttpStatus)HttpStatus.NO_CONTENT);
    }
}

